/*
 * Decompiled with CFR 0.152.
 */
package snownee.passablefoliage;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import snownee.passablefoliage.PassableFoliageBlock;
import snownee.passablefoliage.PassableFoliageCommonConfig;
import snownee.passablefoliage.enchantment.EnchantmentModule;

public final class PassableFoliage {
    public static final String ID = "passablefoliage";
    public static boolean enchantmentEnabled;
    public static ThreadLocal<Boolean> suppressPassableCheck;

    public static void onEntityCollidedWithLeaves(Level world, BlockPos pos, BlockState blockState, Entity entity) {
        Player player;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity instanceof Player && (player = (Player)entity).m_7500_() && player.m_150110_().f_35935_) {
            return;
        }
        if (!entity.m_20159_()) {
            PassableFoliage.setSuppressPassableCheck(true);
            if (!entity.m_20039_(pos, blockState)) {
                PassableFoliage.setSuppressPassableCheck(false);
                return;
            }
            PassableFoliage.setSuppressPassableCheck(false);
        }
        if ((!PassableFoliageCommonConfig.soundsPlayerOnly || entity instanceof Player) && blockState.m_204336_(BlockTags.f_13035_)) {
            double motion;
            if (livingEntity.f_19789_ > 3.0f) {
                entity.m_5496_(SoundEvents.f_11988_, SoundType.f_56740_.m_56773_() * 0.6f * PassableFoliageCommonConfig.soundVolume, SoundType.f_56740_.m_56774_() * 0.65f);
            } else if (world.m_46467_() % 6L == 0L && (motion = entity.m_20184_().m_82556_()) > 5.0E-7) {
                entity.m_5496_(SoundEvents.f_11990_, SoundType.f_56740_.m_56773_() * 0.5f * PassableFoliageCommonConfig.soundVolume, SoundType.f_56740_.m_56774_() * 0.45f);
            }
        }
        float h = 1.0f;
        float v = 1.0f;
        if (!PassableFoliage.hasLeafWalker(livingEntity) && livingEntity.m_20184_().m_7098_() <= 0.0) {
            v = PassableFoliageCommonConfig.speedReductionVertical;
            h = PassableFoliageCommonConfig.speedReductionHorizontal;
        }
        if (h < 1.0f || v < 1.0f) {
            Vec3 newMotion = entity.m_20184_().m_82542_((double)h, (double)v, (double)h);
            entity.m_20256_(newMotion);
        }
        if (livingEntity.f_19789_ > (float)PassableFoliageCommonConfig.fallDamageThreshold) {
            livingEntity.f_19789_ -= (float)PassableFoliageCommonConfig.fallDamageThreshold;
            livingEntity.m_142535_((float)PassableFoliageCommonConfig.fallDamageThreshold, 1.0f - PassableFoliageCommonConfig.fallDamageReduction, world.m_269111_().m_268989_());
        }
        if (livingEntity.f_19789_ > 1.0f) {
            livingEntity.f_19789_ = 1.0f;
        }
        if (entity.m_20160_()) {
            for (Entity ent : entity.m_20197_()) {
                PassableFoliage.onEntityCollidedWithLeaves(world, pos, blockState, ent);
            }
        }
    }

    public static boolean isPassable(BlockState state) {
        return ((PassableFoliageBlock)state.m_60734_()).pfoliage$isPassable() && suppressPassableCheck.get() == false;
    }

    public static boolean hasLeafWalker(LivingEntity entity) {
        return PassableFoliageCommonConfig.alwaysLeafWalking || enchantmentEnabled && EnchantmentHelper.m_44836_((Enchantment)((Enchantment)EnchantmentModule.LEAF_WALKER.get()), (LivingEntity)entity) > 0;
    }

    public static void setSuppressPassableCheck(boolean suppressPassableCheck) {
        PassableFoliage.suppressPassableCheck.set(suppressPassableCheck);
    }

    static {
        suppressPassableCheck = ThreadLocal.withInitial(() -> false);
    }
}

