/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.events;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.model.entity.StaticRatModel;
import com.github.alexthe666.rats.client.render.RatsRenderType;
import com.github.alexthe666.rats.client.render.entity.RatProtectorRenderer;
import com.github.alexthe666.rats.client.util.RatsIconRenderUtil;
import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsCapabilityRegistry;
import com.github.alexthe666.rats.registry.RatsEffectRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import com.github.alexthe666.rats.server.block.entity.RatQuarryBlockEntity;
import com.github.alexthe666.rats.server.capability.SelectedRatCapability;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.events.ForgeEvents;
import com.github.alexthe666.rats.server.items.RatStaffItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="rats", value={Dist.CLIENT})
public class ForgeClientEvents {
    public static final ResourceLocation PLAGUE_HEART_TEXTURE = new ResourceLocation("rats", "textures/gui/plague_hearts.png");
    private static final ResourceLocation RADIUS_TEXTURE = new ResourceLocation("rats", "textures/misc/rat_radius.png");
    private static final ResourceLocation QUARRY_TEXTURE = new ResourceLocation("rats", "textures/misc/quarry_radius.png");
    private static final ResourceLocation HOME_TEXTURE = new ResourceLocation("rats", "textures/misc/rat_home.png");
    private static final ResourceLocation RAT_DEPOSIT_TEXTURE = new ResourceLocation("rats", "textures/misc/rat_deposit.png");
    private static final ResourceLocation RAT_PICKUP_TEXTURE = new ResourceLocation("rats", "textures/misc/rat_pickup.png");
    private static final ResourceLocation RAT_PATROL_NODE_TEXTURE = new ResourceLocation("rats:textures/misc/rat_patrol.png");
    private static final ResourceLocation SYNESTHESIA = new ResourceLocation("rats", "shaders/post/synesthesia.json");
    private static float synesthesiaProgress = 0.0f;
    private static float prevSynesthesiaProgress = 0.0f;
    private static final float MAX_SYNESTESIA = 40.0f;
    private static final StaticRatModel<LivingEntity> RAT_MODEL = new StaticRatModel();

    @SubscribeEvent
    public static void adjustSynesthesiaFOV(ViewportEvent.ComputeFov event) {
        if (RatConfig.synesthesiaShader && prevSynesthesiaProgress > 0.0f) {
            float prog = prevSynesthesiaProgress + (synesthesiaProgress - prevSynesthesiaProgress) * Minecraft.m_91087_().getPartialTick();
            float renderProg = prevSynesthesiaProgress <= synesthesiaProgress ? (float)Math.sin((double)(prog / 40.0f) * Math.PI) * 40.0f : -((float)Math.sin((double)(prog / 40.0f) * Math.PI)) * 40.0f;
            event.setFOV(event.getFOV() + (double)((float)Mth.m_14139_((double)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()), (double)1.0, (double)renderProg)));
        }
    }

    @SubscribeEvent
    public static void changeRatlantisBowFov(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        if (player.m_6117_() && player.m_21211_().m_150930_((Item)RatlantisItemRegistry.RATLANTIS_BOW.get())) {
            float f = (float)player.m_21252_() / 10.0f;
            f = f > 1.0f ? 1.0f : f * f;
            event.setNewFovModifier((float)Mth.m_14139_((double)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()), (double)1.0, (double)(event.getFovModifier() * (1.0f - f * 0.15f))));
        }
    }

    @SubscribeEvent
    public static void removeAutomatonHeadOutline(RenderHighlightEvent.Block event) {
        BlockState state = event.getCamera().m_90592_().m_9236_().m_8055_(event.getTarget().m_82425_());
        if (state.m_60713_((Block)RatlantisBlockRegistry.MARBLED_CHEESE_RAT_HEAD.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (RatConfig.synesthesiaShader && event.getEntity() == Minecraft.m_91087_().f_91074_) {
            GameRenderer renderer = Minecraft.m_91087_().f_91063_;
            boolean active = event.getEntity().m_21023_((MobEffect)RatsEffectRegistry.SYNESTHESIA.get());
            try {
                if (active && renderer.m_109149_() == null) {
                    renderer.m_109128_(SYNESTHESIA);
                }
                if (!active && renderer.m_109149_() != null && SYNESTHESIA.toString().equals(Objects.requireNonNull(renderer.m_109149_()).m_110022_())) {
                    renderer.m_109086_();
                }
            }
            catch (Exception e) {
                RatsMod.LOGGER.warn("Game tried to crash when applying shader");
            }
            if (prevSynesthesiaProgress == 2.0f && active) {
                event.getEntity().m_9236_().m_245747_(event.getEntity().m_20183_(), (SoundEvent)RatsSoundRegistry.POTION_EFFECT_BEGIN.get(), SoundSource.NEUTRAL, 16.0f, 1.0f, false);
            }
            if (prevSynesthesiaProgress == 38.0f && !active) {
                event.getEntity().m_9236_().m_245747_(event.getEntity().m_20183_(), (SoundEvent)RatsSoundRegistry.POTION_EFFECT_END.get(), SoundSource.NEUTRAL, 16.0f, 1.0f, false);
            }
            prevSynesthesiaProgress = synesthesiaProgress;
            if (active && synesthesiaProgress < 40.0f) {
                synesthesiaProgress += 2.0f;
            } else if (!active && synesthesiaProgress > 0.0f) {
                synesthesiaProgress -= 2.0f;
            }
        }
    }

    @SubscribeEvent
    public static void unrenderHatLayerWithMask(RenderLivingEvent.Pre<?, ?> event) {
        EntityModel entityModel;
        boolean visible;
        ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
        boolean bl = visible = !stack.m_150930_((Item)RatsItemRegistry.BLACK_DEATH_MASK.get()) && !stack.m_150930_((Item)RatsItemRegistry.PLAGUE_DOCTOR_MASK.get()) && !stack.m_150930_(((Block)RatlantisBlockRegistry.MARBLED_CHEESE_RAT_HEAD.get()).m_5456_());
        if (!visible && (entityModel = event.getRenderer().m_7200_()) instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)entityModel;
            if (event.getRenderer().m_7200_() instanceof HeadedModel) {
                humanoidModel.f_102809_.f_104207_ = false;
            }
        }
    }

    @SubscribeEvent
    public static void addTooltipWhenRatlantisIsDisabled(ItemTooltipEvent event) {
        if (event.getEntity() != null && !RatsMod.RATLANTIS_DATAPACK_ENABLED && !RatsMod.RATLANTIS_ITEMS.isEmpty() && RatsMod.RATLANTIS_ITEMS.contains(event.getItemStack().m_41720_())) {
            event.getToolTip().clear();
            event.getToolTip().add(Component.m_237119_().m_7220_(event.getItemStack().m_41786_()).m_130938_(event.getItemStack().m_41791_().getStyleModifier()));
            event.getToolTip().add(Component.m_237115_((String)"item.rats.ratlantis_disabled.desc0").m_130940_(ChatFormatting.DARK_RED));
            event.getToolTip().add(Component.m_237115_((String)"item.rats.ratlantis_disabled.desc1").m_130940_(ChatFormatting.GRAY));
            event.getToolTip().add(Component.m_237115_((String)"item.rats.ratlantis_disabled.desc2").m_130940_(ChatFormatting.GRAY));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        int currentHeart;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        if (event.getOverlay() != VanillaGuiOverlay.PLAYER_HEALTH.type() || event.isCanceled() || !player.m_21023_((MobEffect)RatsEffectRegistry.PLAGUE.get()) || !RatConfig.plagueHearts) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        int leftHeight = 39;
        RenderSystem.enableBlend();
        int health = Mth.m_14167_((float)player.m_21223_());
        Gui gui = Minecraft.m_91087_().f_91065_;
        boolean highlight = gui.f_92976_ > (long)gui.m_93079_() && (gui.f_92976_ - (long)gui.m_93079_()) / 3L % 2L == 1L;
        long j = Util.m_137550_();
        if (health < gui.f_92973_ && player.f_19802_ > 0) {
            gui.f_92975_ = j;
            gui.f_92976_ = gui.m_93079_() + 20;
        } else if (health > gui.f_92973_ && player.f_19802_ > 0) {
            gui.f_92975_ = j;
            gui.f_92976_ = gui.m_93079_() + 10;
        }
        if (j - gui.f_92975_ > 1000L) {
            gui.f_92974_ = health;
            gui.f_92975_ = j;
        }
        gui.f_92973_ = health;
        int healthLast = gui.f_92974_;
        if (RatConfig.singleRowPlagueHearts) {
            gui.f_92985_.m_188584_((long)gui.m_93079_() * 312871L);
        } else {
            gui.f_92985_.m_188584_((long)(gui.m_93079_() * 312871));
        }
        AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = Math.max((float)attrMaxHealth.m_22135_(), (float)Math.max(healthLast, health));
        int absorption = Mth.m_14167_((float)player.m_6103_());
        int healthRows = Mth.m_14167_((float)((healthMax + (float)absorption) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int left = width / 2 - 91;
        int top = height - leftHeight;
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = gui.m_93079_() % (RatConfig.singleRowPlagueHearts ? 25 : Mth.m_14167_((float)(healthMax + 5.0f)));
        }
        int healthAmount = Mth.m_14165_((double)((double)healthMax / 2.0));
        int n = currentHeart = RatConfig.singleRowPlagueHearts ? Math.min(9, healthAmount + absorption - 1) : healthAmount + absorption - 1;
        while (currentHeart >= 0) {
            boolean halfHeart;
            int k2;
            int y;
            int heartYPos = RatConfig.singleRowPlagueHearts ? 18 : 0;
            int emptyHeartYPos = RatConfig.singleRowPlagueHearts ? 27 : 9;
            int x = left + currentHeart % 10 * 8;
            int n2 = y = RatConfig.singleRowPlagueHearts ? top : top - currentHeart / 10 * rowHeight;
            if (health + absorption <= 4) {
                y += gui.f_92985_.m_188503_(2);
            }
            if (currentHeart < healthAmount && currentHeart == regen) {
                y -= 2;
            }
            if (!RatConfig.singleRowPlagueHearts) {
                graphics.m_280218_(PLAGUE_HEART_TEXTURE, x, y, 0, emptyHeartYPos, 9, 9);
            }
            int fullHealth = currentHeart * 2;
            if (!RatConfig.singleRowPlagueHearts && currentHeart >= healthAmount && (k2 = fullHealth - health * 2) < absorption) {
                boolean halfHeart2 = k2 + 1 == absorption;
                graphics.m_280218_(PLAGUE_HEART_TEXTURE, x, y, halfHeart2 ? 9 : 0, heartYPos, 9, 9);
            }
            if (highlight && fullHealth < healthLast) {
                halfHeart = fullHealth + 1 == healthLast;
                graphics.m_280218_(PLAGUE_HEART_TEXTURE, x, y, halfHeart ? 9 : 0, heartYPos, 9, 9);
            }
            if (fullHealth < health) {
                halfHeart = fullHealth + 1 == health;
                graphics.m_280218_(PLAGUE_HEART_TEXTURE, x, y, halfHeart ? 9 : 0, heartYPos, 9, 9);
            }
            --currentHeart;
        }
        RenderSystem.disableBlend();
        Minecraft.m_91087_().m_91307_().m_7241_();
    }

    @SubscribeEvent
    public static void onFogColors(ViewportEvent.ComputeFogColor event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && level.m_46472_().equals(RatlantisDimensionRegistry.DIMENSION_KEY)) {
            float f12 = Mth.m_14036_((float)(Mth.m_14089_((float)(level.m_46942_((float)event.getPartialTick()) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
            FluidState fluidstate = event.getCamera().getBlockAtCamera().m_60819_();
            if (!fluidstate.m_205070_(FluidTags.f_13131_)) {
                event.setRed(f12);
                event.setGreen(f12);
                event.setBlue(f12 * 0.7f);
            }
        }
    }

    @SubscribeEvent
    public static <T extends LivingEntity, M extends EntityModel<T>> void onLivingRender(RenderLivingEvent.Post<T, M> event) {
        if (event.getEntity() instanceof Player) {
            PoseStack stack = event.getPoseStack();
            int protectorCount = ForgeEvents.getProtectorCount(event.getEntity());
            VertexConsumer textureBuilder = event.getMultiBufferSource().m_6299_(RatsRenderType.getGlowingTranslucent(RatProtectorRenderer.BASE_TEXTURE));
            for (int i = 0; i < protectorCount; ++i) {
                float tick = (float)(event.getEntity().f_19797_ - 1) + event.getPartialTick();
                float offsetRot = 30.0f + 360.0f * ((float)i / (float)protectorCount);
                float bob = (float)((Math.sin(tick * 0.1f) * (double)0.2f + Math.cos(tick * 0.4f + (float)i)) * 0.2);
                float scale = 0.4f;
                float rotation = Mth.m_14177_((float)(tick * 8.0f % 360.0f + offsetRot));
                stack.m_85836_();
                stack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                stack.m_85837_(0.0, (double)event.getEntity().m_20206_() + 0.5 + (double)bob, (double)(event.getEntity().m_20205_() + 0.5f));
                stack.m_85836_();
                stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252529_.m_252977_(75.0f));
                stack.m_85841_(scale, scale, scale);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                float f = ((float)event.getEntity().f_19797_ + event.getPartialTick()) * 0.5f;
                float f1 = 1.0f;
                RAT_MODEL.m_6973_(event.getEntity(), f, f1, (float)event.getEntity().f_19797_ + event.getPartialTick(), event.getPartialTick(), 0.0f);
                RAT_MODEL.m_7695_(event.getPoseStack(), textureBuilder, event.getPackedLight(), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                stack.m_85849_();
                stack.m_85849_();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        block10: {
            double pz;
            double py;
            double px;
            Vec3 viewPosition;
            float bob;
            PoseStack stack;
            BufferBuilder buffer;
            Tesselator tessellator;
            ItemStack heldItem;
            TamedRat rat;
            block11: {
                BlockEntity blockEntity;
                if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES || Minecraft.m_91087_().f_91074_ == null || !Minecraft.m_91087_().f_91074_.getCapability(RatsCapabilityRegistry.SELECTED_RAT).resolve().isPresent()) break block10;
                rat = ((SelectedRatCapability)Minecraft.m_91087_().f_91074_.getCapability(RatsCapabilityRegistry.SELECTED_RAT).resolve().get()).getSelectedRat();
                if (rat == null) {
                    return;
                }
                heldItem = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
                tessellator = Tesselator.m_85913_();
                buffer = tessellator.m_85915_();
                stack = event.getPoseStack();
                bob = 1.5f + 0.3f * (Mth.m_14031_((float)((event.getPartialTick() + (float)Minecraft.m_91087_().f_91074_.f_19797_) * 0.1f)) + 1.0f);
                viewPosition = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_();
                px = viewPosition.f_82479_;
                py = viewPosition.f_82480_;
                pz = viewPosition.f_82481_;
                if (!heldItem.m_150930_((Item)RatsItemRegistry.CHEESE_STICK.get())) break block11;
                float finalBob = bob;
                rat.getDepositPos().ifPresent(pos -> {
                    if (Minecraft.m_91087_().f_91074_.m_9236_().m_46749_(pos.m_122646_()) && pos.m_122640_().equals(rat.m_9236_().m_46472_())) {
                        RatsIconRenderUtil.renderPOIIcon(RAT_DEPOSIT_TEXTURE, viewPosition, pos.m_122646_(), finalBob, stack, buffer, tessellator);
                    }
                });
                rat.getPickupPos().ifPresent(pos -> {
                    if (Minecraft.m_91087_().f_91074_.m_9236_().m_46749_(pos.m_122646_()) && pos.m_122640_().equals(rat.m_9236_().m_46472_())) {
                        RatsIconRenderUtil.renderPOIIcon(RAT_PICKUP_TEXTURE, viewPosition, pos.m_122646_(), finalBob, stack, buffer, tessellator);
                    }
                });
                rat.getHomePoint().ifPresent(pos -> {
                    if (Minecraft.m_91087_().f_91074_.m_9236_().m_46749_(pos.m_122646_()) && pos.m_122640_().equals(rat.m_9236_().m_46472_())) {
                        RatsIconRenderUtil.renderPOIIcon(HOME_TEXTURE, viewPosition, pos.m_122646_(), finalBob, stack, buffer, tessellator);
                    }
                });
                if (Minecraft.m_91087_().f_91077_ == null || Minecraft.m_91087_().f_91077_.m_6662_() != HitResult.Type.BLOCK) break block10;
                BlockHitResult over = (BlockHitResult)Minecraft.m_91087_().f_91077_;
                if (Minecraft.m_91087_().f_91073_ == null || !Minecraft.m_91087_().f_91073_.m_8055_(over.m_82425_()).m_60713_((Block)RatsBlockRegistry.RAT_QUARRY.get()) || !((blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(over.m_82425_())) instanceof RatQuarryBlockEntity)) break block10;
                RatQuarryBlockEntity quarry = (RatQuarryBlockEntity)blockEntity;
                BlockPos blockPos = quarry.m_58899_().m_7918_(-quarry.getRadius(), 0, -quarry.getRadius());
                AABB aabb = new AABB(0.0, -0.05, 0.0, (double)(1 + quarry.getRadius() * 2), 0.1, (double)(1 + quarry.getRadius() * 2));
                RatsIconRenderUtil.renderBox(QUARRY_TEXTURE, viewPosition, Vec3.m_82528_((Vec3i)blockPos), aabb, stack);
                break block10;
            }
            if (heldItem.m_150930_((Item)RatsItemRegistry.RADIUS_STICK.get())) {
                BlockPos blockPos = rat.getSearchCenter();
                if (!Minecraft.m_91087_().f_91074_.m_9236_().m_46749_(blockPos)) {
                    return;
                }
                Vec3 renderCenter = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                double renderRadius = rat.getRadius();
                AABB aabb = new AABB(-renderRadius, -renderRadius, -renderRadius, renderRadius, renderRadius, renderRadius);
                RatsIconRenderUtil.renderBox(RADIUS_TEXTURE, viewPosition, renderCenter, aabb, stack);
            } else if (heldItem.m_150930_((Item)RatsItemRegistry.PATROL_STICK.get())) {
                bob = 1.5f + 0.05f * (Mth.m_14031_((float)((event.getPartialTick() + (float)Minecraft.m_91087_().f_91074_.f_19797_) * 0.1f)) + 1.0f);
                for (int i = 0; i < rat.getPatrolNodes().size(); ++i) {
                    GlobalPos prev;
                    GlobalPos node = rat.getPatrolNodes().get(i);
                    if (!Minecraft.m_91087_().f_91074_.m_9236_().m_46749_(node.m_122646_())) {
                        return;
                    }
                    float r = 0.6f;
                    float g = 0.1f;
                    float b = 0.1f;
                    if (i > 0) {
                        prev = rat.getPatrolNodes().get(i - 1);
                    } else {
                        prev = rat.getPatrolNodes().get(rat.getPatrolNodes().size() - 1);
                        r = 0.5f;
                        g = 0.3f;
                    }
                    if (node.m_122640_().equals(Minecraft.m_91087_().f_91074_.m_9236_().m_46472_()) && prev.m_122640_().equals(Minecraft.m_91087_().f_91074_.m_9236_().m_46472_())) {
                        stack.m_85836_();
                        stack.m_85837_(-px, -py, -pz);
                        stack.m_252880_((float)prev.m_122646_().m_123341_() + 0.5f, (float)prev.m_122646_().m_123342_() + bob - 0.25f, (float)prev.m_122646_().m_123343_() + 0.5f);
                        float pdx = node.m_122646_().m_123341_() - prev.m_122646_().m_123341_();
                        float pdy = node.m_122646_().m_123342_() - prev.m_122646_().m_123342_();
                        float pdz = node.m_122646_().m_123343_() - prev.m_122646_().m_123343_();
                        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                        Matrix4f matrix4f = stack.m_85850_().m_252922_();
                        buffer.m_252986_(matrix4f, pdx, pdy, pdz).m_85950_(r, g, b, 1.0f).m_5752_();
                        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                        tessellator.m_85914_();
                        stack.m_85849_();
                    }
                    if (!node.m_122640_().equals(Minecraft.m_91087_().f_91074_.m_9236_().m_46472_())) continue;
                    RatsIconRenderUtil.renderPOIIcon(RAT_PATROL_NODE_TEXTURE, viewPosition, node.m_122646_(), bob, stack, buffer, tessellator);
                }
            }
        }
    }

    public static boolean isRatSelectedOnStaff(TamedRat rat) {
        LocalPlayer player;
        if (Minecraft.m_91087_().f_91074_ != null && ((player = Minecraft.m_91087_().f_91074_).m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof RatStaffItem || player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof RatStaffItem)) {
            LazyOptional cap = player.getCapability(RatsCapabilityRegistry.SELECTED_RAT);
            return cap.resolve().isPresent() && Objects.equals((Object)((SelectedRatCapability)cap.resolve().get()).getSelectedRat(), (Object)rat);
        }
        return false;
    }
}

