/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.model.entity;

import com.github.alexthe666.rats.server.entity.mount.RatStriderMount;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class RatStriderMountModel<T extends RatStriderMount>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart body;
    private final ModelPart rightBottomBristle;
    private final ModelPart rightMiddleBristle;
    private final ModelPart rightTopBristle;
    private final ModelPart leftTopBristle;
    private final ModelPart leftMiddleBristle;
    private final ModelPart leftBottomBristle;

    public RatStriderMountModel(ModelPart root) {
        this.root = root;
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
        this.body = root.m_171324_("body");
        this.rightBottomBristle = this.body.m_171324_("right_bottom_bristle");
        this.rightMiddleBristle = this.body.m_171324_("right_middle_bristle");
        this.rightTopBristle = this.body.m_171324_("right_top_bristle");
        this.leftTopBristle = this.body.m_171324_("left_top_bristle");
        this.leftMiddleBristle = this.body.m_171324_("left_middle_bristle");
        this.leftBottomBristle = this.body.m_171324_("left_bottom_bristle");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f), PartPose.m_171419_((float)-4.0f, (float)8.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 55).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f), PartPose.m_171419_((float)4.0f, (float)8.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -6.0f, -8.0f, 16.0f, 14.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        body.m_171599_("right_bottom_bristle", CubeListBuilder.m_171558_().m_171514_(16, 65).m_171506_(-12.0f, 0.0f, 0.0f, 12.0f, 0.0f, 16.0f, true), PartPose.m_171423_((float)-8.0f, (float)4.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-1.2217305f));
        body.m_171599_("right_middle_bristle", CubeListBuilder.m_171558_().m_171514_(16, 49).m_171506_(-12.0f, 0.0f, 0.0f, 12.0f, 0.0f, 16.0f, true), PartPose.m_171423_((float)-8.0f, (float)-1.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-1.134464f));
        body.m_171599_("right_top_bristle", CubeListBuilder.m_171558_().m_171514_(16, 33).m_171506_(-12.0f, 0.0f, 0.0f, 12.0f, 0.0f, 16.0f, true), PartPose.m_171423_((float)-8.0f, (float)-5.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-0.87266463f));
        body.m_171599_("left_top_bristle", CubeListBuilder.m_171558_().m_171514_(16, 33).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 0.0f, 16.0f), PartPose.m_171423_((float)8.0f, (float)-6.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.87266463f));
        body.m_171599_("left_middle_bristle", CubeListBuilder.m_171558_().m_171514_(16, 49).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 0.0f, 16.0f), PartPose.m_171423_((float)8.0f, (float)-2.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)1.134464f));
        body.m_171599_("left_bottom_bristle", CubeListBuilder.m_171558_().m_171514_(16, 65).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 0.0f, 16.0f), PartPose.m_171423_((float)8.0f, (float)3.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)1.2217305f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(RatStriderMount mount, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        limbSwingAmount = Math.min(0.25f, limbSwingAmount);
        if (!mount.m_20160_()) {
            this.body.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.body.f_104204_ = headYaw * ((float)Math.PI / 180);
        } else {
            this.body.f_104203_ = 0.0f;
            this.body.f_104204_ = 0.0f;
        }
        this.body.f_104205_ = 0.1f * Mth.m_14031_((float)(limbSwing * 1.5f)) * 4.0f * limbSwingAmount;
        this.body.f_104201_ = 2.0f;
        this.body.f_104201_ -= 2.0f * Mth.m_14089_((float)(limbSwing * 1.5f)) * 2.0f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14031_((float)(limbSwing * 1.5f * 0.5f)) * 2.0f * limbSwingAmount;
        this.rightLeg.f_104203_ = Mth.m_14031_((float)(limbSwing * 1.5f * 0.5f + (float)Math.PI)) * 2.0f * limbSwingAmount;
        this.leftLeg.f_104205_ = 0.17453292f * Mth.m_14089_((float)(limbSwing * 1.5f * 0.5f)) * limbSwingAmount;
        this.rightLeg.f_104205_ = 0.17453292f * Mth.m_14089_((float)(limbSwing * 1.5f * 0.5f + (float)Math.PI)) * limbSwingAmount;
        this.leftLeg.f_104201_ = 8.0f + 2.0f * Mth.m_14031_((float)(limbSwing * 1.5f * 0.5f + (float)Math.PI)) * 2.0f * limbSwingAmount;
        this.rightLeg.f_104201_ = 8.0f + 2.0f * Mth.m_14031_((float)(limbSwing * 1.5f * 0.5f)) * 2.0f * limbSwingAmount;
        this.rightBottomBristle.f_104205_ = -1.2217305f;
        this.rightMiddleBristle.f_104205_ = -1.134464f;
        this.rightTopBristle.f_104205_ = -0.87266463f;
        this.leftTopBristle.f_104205_ = 0.87266463f;
        this.leftMiddleBristle.f_104205_ = 1.134464f;
        this.leftBottomBristle.f_104205_ = 1.2217305f;
        float f1 = Mth.m_14089_((float)(limbSwing * 1.5f + (float)Math.PI)) * limbSwingAmount;
        this.rightBottomBristle.f_104205_ += f1 * 1.3f;
        this.rightMiddleBristle.f_104205_ += f1 * 1.2f;
        this.rightTopBristle.f_104205_ += f1 * 0.6f;
        this.leftTopBristle.f_104205_ += f1 * 0.6f;
        this.leftMiddleBristle.f_104205_ += f1 * 1.2f;
        this.leftBottomBristle.f_104205_ += f1 * 1.3f;
        this.rightBottomBristle.f_104205_ += 0.05f * Mth.m_14031_((float)(ageInTicks * 1.0f * -0.4f));
        this.rightMiddleBristle.f_104205_ += 0.1f * Mth.m_14031_((float)(ageInTicks * 1.0f * 0.2f));
        this.rightTopBristle.f_104205_ += 0.1f * Mth.m_14031_((float)(ageInTicks * 1.0f * 0.4f));
        this.leftTopBristle.f_104205_ += 0.1f * Mth.m_14031_((float)(ageInTicks * 1.0f * 0.4f));
        this.leftMiddleBristle.f_104205_ += 0.1f * Mth.m_14031_((float)(ageInTicks * 1.0f * 0.2f));
        this.leftBottomBristle.f_104205_ += 0.05f * Mth.m_14031_((float)(ageInTicks * 1.0f * -0.4f));
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

