/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity.layer;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.client.model.entity.AbstractRatModel;
import com.github.alexthe666.rats.client.render.RatsRenderType;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesOverlayUpgrade;
import com.github.alexthe666.rats.server.misc.RatColorUtil;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TamedRatOverlayLayer
extends RenderLayer<TamedRat, AbstractRatModel<TamedRat>> {
    private static final RenderType TEXTURE_DYED_NOT = RenderType.m_110476_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/undyed_part.png"));
    private static final RenderType TEXTURE_DYED = RenderType.m_110482_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/dyed_part.png"));
    private static final RenderType TOGA_TEX = RenderType.m_110476_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/upgrades/toga.png"));

    public TamedRatOverlayLayer(RenderLayerParent<TamedRat, AbstractRatModel<TamedRat>> parent) {
        super(parent);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, TamedRat rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (rat.getRespawnCountdown() > 0 && RatConfig.ratAngelGlint) {
            VertexConsumer consumer = buffer.m_6299_(RatsRenderType.getWhiteGlint());
            ((AbstractRatModel)this.m_117386_()).m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (rat.m_8077_() && rat.m_7770_().getString().equalsIgnoreCase("ultrakill")) {
            VertexConsumer vertexBuilder = buffer.m_6299_(RatsRenderType.getGreenGlint());
            ((AbstractRatModel)this.m_117386_()).m_7695_(stack, vertexBuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            VertexConsumer consumer;
            if (RatUpgradeUtils.hasUpgrade(rat, (Item)RatsItemRegistry.RAT_UPGRADE_GOD.get()) && RatConfig.ratGodGlint) {
                VertexConsumer vertexBuilder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)RenderType.m_110458_((ResourceLocation)this.m_117347_((Entity)rat)), (boolean)false, (boolean)true);
                ((AbstractRatModel)this.m_117386_()).m_7695_(stack, vertexBuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (rat.isDyed()) {
                if (rat.getDyeColor() == 100) {
                    RenderType type = RatsRenderType.GlintType.getRenderTypeBasedOnKeyword(rat.getSpecialDye());
                    consumer = buffer.m_6299_(type != null ? type : RatsRenderType.getRainbowGlint());
                    ((AbstractRatModel)this.m_117386_()).m_7695_(stack, consumer, light, LivingEntityRenderer.m_115338_((LivingEntity)rat, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                    if (!RatUpgradeUtils.hasUpgrade(rat, (Item)RatsItemRegistry.RAT_UPGRADE_UNDEAD.get())) {
                        VertexConsumer consumer1 = buffer.m_6299_(TEXTURE_DYED_NOT);
                        ((AbstractRatModel)this.m_117386_()).m_7695_(stack, consumer1, light, LivingEntityRenderer.m_115338_((LivingEntity)rat, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                } else {
                    consumer = buffer.m_6299_(TEXTURE_DYED);
                    float[] color = RatColorUtil.getDyeRgb(DyeColor.m_41053_((int)rat.getDyeColor()));
                    ((AbstractRatModel)this.m_117386_()).m_7695_(stack, consumer, light, LivingEntityRenderer.m_115338_((LivingEntity)rat, (float)0.0f), color[0], color[1], color[2], 1.0f);
                }
            }
            RatUpgradeUtils.forEachUpgrade(rat, item -> item instanceof ChangesOverlayUpgrade, (upgrade, slot) -> {
                RenderType overlay;
                if (rat.isSlotVisible((EquipmentSlot)slot) && (overlay = ((ChangesOverlayUpgrade)upgrade.m_41720_()).getOverlayTexture((ItemStack)upgrade, rat, partialTicks)) != null) {
                    VertexConsumer consumer = buffer.m_6299_(overlay);
                    ((AbstractRatModel)this.m_117386_()).m_6973_((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    ((AbstractRatModel)this.m_117386_()).m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            });
            if (rat.hasToga()) {
                consumer = buffer.m_6299_(TOGA_TEX);
                ((AbstractRatModel)this.m_117386_()).m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

