/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.registry;

import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public enum RatsArmorMaterialRegistry implements ArmorMaterial
{
    PIPER_HAT("piper_hat", 25, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 2);
    }), 15, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RatsBlockRegistry.PIED_WOOL.get())})),
    CHEF_TOQUE("chef_toque", 0, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 15, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.f_50041_)})),
    PLAGUE_MASK("plague_mask", 25, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 15, SoundEvents.f_11675_, 1.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RatsItemRegistry.PLAGUE_ESSENCE.get())})),
    RATLANTIS("ratlantis", 40, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 5);
        map.put(ArmorItem.Type.LEGGINGS, 8);
        map.put(ArmorItem.Type.CHESTPLATE, 10);
        map.put(ArmorItem.Type.HELMET, 5);
    }), 17, SoundEvents.f_11679_, 4.0f, 0.1f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RatlantisItemRegistry.ORATCHALCUM_INGOT.get())})),
    FARMER_HAT("farmer_hat", 0, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 15, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42129_)})),
    TOP_HAT("top_hat", 0, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 15, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_41938_)})),
    FEZ("fez", 0, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 100, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_41937_)})),
    SANTA_HAT("santa_hat", 0, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 15, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_41937_)})),
    HALO("halo", 0, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 15, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42587_)})),
    CROWN("crown", 0, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 15, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42417_)})),
    GHOST_HAT("ghost_hat", 0, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 15, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RatlantisItemRegistry.GHOST_PIRAT_ECTOPLASM.get())})),
    GENERIC_HAT("generic_hat", 0, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 1);
        map.put(ArmorItem.Type.CHESTPLATE, 1);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 100, SoundEvents.f_11675_, 0.0f, 0.0f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42454_)}));

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantability;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockback;
    private final Supplier<Ingredient> repairMaterial;

    private RatsArmorMaterialRegistry(String name, int durability, EnumMap<ArmorItem.Type, Integer> damageReduction, int enchantability, SoundEvent sound, float toughness, float knockback, Supplier<Ingredient> repairMaterial) {
        this.name = name;
        this.durabilityMultiplier = durability;
        this.protectionFunctionForType = damageReduction;
        this.enchantability = enchantability;
        this.equipSound = sound;
        this.toughness = toughness;
        this.knockback = knockback;
        this.repairMaterial = repairMaterial;
    }

    public String m_6082_() {
        return this.name;
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public Ingredient m_6230_() {
        return this.repairMaterial.get();
    }

    public float m_6649_() {
        return this.knockback;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266653_ -> {
            p_266653_.put(ArmorItem.Type.BOOTS, 13);
            p_266653_.put(ArmorItem.Type.LEGGINGS, 15);
            p_266653_.put(ArmorItem.Type.CHESTPLATE, 16);
            p_266653_.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

