/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.block.entity.DecoratedRatCageBlockEntity;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RatCageBreedingLanternBlockEntity
extends DecoratedRatCageBlockEntity {
    private int breedingCooldown = 0;

    public RatCageBreedingLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.RAT_CAGE_BREEDING_LANTERN.get(), pos, state);
    }

    @Override
    public ItemStack getContainedItem() {
        return new ItemStack((ItemLike)RatsItemRegistry.RAT_BREEDING_LANTERN.get());
    }

    @Override
    public void setContainedItem(ItemStack stack) {
    }

    public int getBreedingCooldown() {
        return this.breedingCooldown;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128405_("BreedingCooldown", this.breedingCooldown);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.breedingCooldown = compound.m_128451_("BreedingCooldown");
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RatCageBreedingLanternBlockEntity te) {
        float f = ((float)RatConfig.ratBreedingCooldown - (float)te.breedingCooldown) / (float)RatConfig.ratBreedingCooldown;
        float f1 = f * 0.6f + 0.4f;
        float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
        float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
        float i = (float)pos.m_123341_() + 0.5f;
        float j = (float)pos.m_123342_() + 0.5f;
        float k = (float)pos.m_123343_() + 0.5f;
        if (te.breedingCooldown <= 0) {
            double d0 = 2.0;
            List rats = level.m_6443_(TamedRat.class, new AABB((double)i - d0, (double)j - d0, (double)k - d0, (double)i + d0, (double)j + d0, (double)k + d0), rat -> !rat.m_6162_() && (rat.isInCage() || rat.isInTube()));
            if (rats.size() < RatConfig.ratCageCramming && !rats.isEmpty()) {
                ArrayList<TamedRat> males = new ArrayList<TamedRat>();
                ArrayList<TamedRat> females = new ArrayList<TamedRat>();
                for (TamedRat rat2 : rats) {
                    if (rat2.breedCooldown != 0) continue;
                    if (rat2.isMale()) {
                        males.add(rat2);
                        continue;
                    }
                    females.add(rat2);
                }
                if (!males.isEmpty() && !females.isEmpty()) {
                    TamedRat male = (TamedRat)((Object)males.get(0));
                    TamedRat female = (TamedRat)((Object)females.get(0));
                    if (males.size() > 1) {
                        male = (TamedRat)((Object)males.get(level.m_213780_().m_188503_(males.size() - 1)));
                    }
                    if (females.size() > 1) {
                        female = (TamedRat)((Object)females.get(level.m_213780_().m_188503_(females.size() - 1)));
                    }
                    male.m_9236_().m_7605_((Entity)male, (byte)83);
                    female.m_9236_().m_7605_((Entity)female, (byte)83);
                    for (int baby = 0; baby < female.m_217043_().m_188503_(RatConfig.maxRatLitterSize) + 1; ++baby) {
                        female.createBabiesFrom(female, male);
                    }
                    te.breedingCooldown = RatConfig.ratBreedingCooldown;
                    male.breedCooldown = RatConfig.ratBreedingCooldown;
                    female.breedCooldown = RatConfig.ratBreedingCooldown;
                }
            }
            if (level.m_5776_()) {
                level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)i + level.m_213780_().m_188500_() - 0.5, (double)j + level.m_213780_().m_188500_() - 0.5, (double)k + level.m_213780_().m_188500_() - 0.5, (double)f1, (double)f2, (double)f3);
            }
        } else {
            --te.breedingCooldown;
        }
    }
}

