/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.RatWorkGoal;
import com.github.alexthe666.rats.server.entity.projectile.SmallArrow;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class RatRangedAttackGoal
extends Goal
implements RatWorkGoal {
    private final TamedRat rat;
    private final double speedModifier;
    private final int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int useTime = 0;

    public RatRangedAttackGoal(TamedRat mob, double speedModifier, int attackCooldown, float attackDistance) {
        this.rat = mob;
        this.speedModifier = speedModifier;
        this.attackCooldown = attackCooldown;
        this.maxAttackDistance = attackDistance * attackDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rat.m_5448_() != null;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.rat.m_21573_().m_26571_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.rat.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.rat.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.useTime = 0;
        this.rat.m_5810_();
    }

    public void m_8037_() {
        LivingEntity entity = this.rat.m_5448_();
        if (entity != null) {
            boolean flag1;
            double d0 = this.rat.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            boolean flag = this.rat.m_21574_().m_148306_((Entity)entity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                this.rat.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.rat.m_21573_().m_5624_((Entity)entity, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.rat.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.rat.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.rat.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.rat.m_21391_((Entity)entity, 30.0f, 30.0f);
            } else {
                this.rat.m_21563_().m_24960_((Entity)entity, 30.0f, 30.0f);
            }
            if (this.useTime > 0) {
                if (!flag && this.seeTime < -60) {
                    this.useTime = 0;
                } else if (flag) {
                    ++this.useTime;
                    if (this.useTime >= (RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_CROSSBOW.get()) ? 40 : 20)) {
                        this.performRangedAttack(entity);
                        this.useTime = 0;
                        this.attackTime = this.attackCooldown;
                    }
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                ++this.useTime;
            }
        }
    }

    public void performRangedAttack(LivingEntity target) {
        new ItemStack((ItemLike)Items.f_42412_);
        SmallArrow arrow = new SmallArrow(this.rat.m_9236_(), (LivingEntity)this.rat);
        double d0 = target.m_20185_() - this.rat.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - arrow.m_20186_();
        double d2 = target.m_20189_() - this.rat.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.rat.m_9236_().m_46791_().m_19028_() * 4);
        if (RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_CROSSBOW.get())) {
            arrow.m_36781_(arrow.m_36789_() + 2.5);
        }
        this.rat.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.rat.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.rat.m_9236_().m_7967_((Entity)arrow);
    }

    @Override
    public RatWorkGoal.TaskType getRatTaskType() {
        return RatWorkGoal.TaskType.ATTACK;
    }
}

