/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.misc;

import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.entity.projectile.LaserBeam;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class LaserPortal
extends Entity {
    public static final Predicate<Entity> MONSTER_NOT_RAT = entity -> !(entity instanceof AbstractRat) && entity instanceof Enemy;
    public float scaleOfPortal;
    public float scaleOfPortalPrev;
    @Nullable
    private LivingEntity creator;
    @Nullable
    private Entity facingTarget;
    private UUID ownerUniqueId;

    public LaserPortal(EntityType<? extends Entity> type, Level level) {
        super(type, level);
    }

    public LaserPortal(EntityType<? extends Entity> type, Level level, double x, double y, double z, LivingEntity creator) {
        this(type, level);
        this.m_6034_(x, y, z);
        this.setCreator(creator);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 300 || this.m_9236_().m_6436_(this.m_20183_()).m_19048_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
        if (this.f_19797_ < 250 && this.scaleOfPortal < 1.0f) {
            this.scaleOfPortal += 0.05f;
        }
        if (this.f_19797_ > 250 && this.scaleOfPortal > 0.0f) {
            this.scaleOfPortal -= 0.05f;
        }
        if (this.f_19797_ % 50 == 0) {
            this.tryFiring();
        } else {
            this.faceTarget();
        }
        if (this.m_9236_().m_5776_() && this.scaleOfPortal >= 0.5f) {
            this.m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.LIGHTNING.get(), this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_()) - (double)this.m_20205_() / 2.0, this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_()) - (double)this.m_20205_() / 2.0, 0.0, 0.0, 0.0);
        }
        this.scaleOfPortalPrev = this.scaleOfPortal;
    }

    private void faceTarget() {
        LivingEntity livingEntity;
        Mob mob;
        LivingEntity livingEntity2;
        if ((this.facingTarget == null || this.getCreator() != null && (livingEntity2 = this.getCreator()) instanceof Mob && ((mob = (Mob)livingEntity2).m_5448_() == null || !this.facingTarget.m_7306_((Entity)mob.m_5448_()))) && this.getCreator() != null && (livingEntity = this.getCreator()) instanceof Mob) {
            Mob mob2 = (Mob)livingEntity;
            LivingEntity target = mob2.m_5448_();
            if (target == null && this.getCreator() instanceof Monster) {
                target = this.m_9236_().m_45930_((Entity)this, 30.0);
            }
            this.facingTarget = target;
        }
        if (this.facingTarget != null) {
            double d0 = this.m_20185_() - this.facingTarget.m_20185_();
            double d2 = this.m_20189_() - this.facingTarget.m_20189_();
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.m_146922_(f % 360.0f);
        }
    }

    private void tryFiring() {
        if (this.getCreator() != null && this.getCreator() instanceof Mob) {
            LivingEntity target = ((Mob)this.getCreator()).m_5448_();
            if (target == null && this.getCreator() instanceof Monster) {
                target = this.m_9236_().m_45930_((Entity)this, 30.0);
            }
            if (target == null && this.getCreator() instanceof TamedRat) {
                LivingEntity closest = null;
                for (Entity entity : this.m_9236_().m_6249_((Entity)this.getCreator(), this.m_20191_().m_82377_(40.0, 10.0, 40.0), MONSTER_NOT_RAT)) {
                    if (!(entity instanceof LivingEntity) || closest != null && !(entity.m_20280_((Entity)this) < closest.m_20280_((Entity)this))) continue;
                    closest = (LivingEntity)entity;
                }
                target = closest;
            }
            if (target != null) {
                double d0 = this.m_20185_() - target.m_20185_();
                double d2 = this.m_20189_() - target.m_20189_();
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.m_146922_(f % 360.0f);
                double targetRelativeX = target.m_20185_() - this.m_20185_();
                double targetRelativeY = target.m_20186_() + (double)(target.m_20206_() / 2.0f) - this.m_20186_() - 1.0;
                double targetRelativeZ = target.m_20189_() - this.m_20189_();
                LaserBeam beam = new LaserBeam((EntityType<? extends ArrowlikeProjectile>)((EntityType)RatlantisEntityRegistry.LASER_BEAM.get()), this.m_9236_(), this.getCreator());
                this.m_5496_((SoundEvent)RatsSoundRegistry.LASER.get(), 1.0f, 0.75f + this.f_19796_.m_188501_() * 0.5f);
                beam.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                beam.m_6686_(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.4f);
                if (!this.m_9236_().m_5776_()) {
                    this.m_9236_().m_7967_((Entity)beam);
                }
            }
        }
    }

    @Nullable
    public LivingEntity getCreator() {
        Entity entity;
        if (this.creator == null && this.ownerUniqueId != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUniqueId)) instanceof LivingEntity) {
            this.creator = (LivingEntity)entity;
        }
        return this.creator;
    }

    public void setCreator(@Nullable LivingEntity entity) {
        this.creator = entity;
        this.ownerUniqueId = entity == null ? null : entity.m_20148_();
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_19797_ = compound.m_128451_("Age");
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUniqueId = compound.m_128342_("OwnerUUID");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Age", this.f_19797_);
        if (this.ownerUniqueId != null) {
            compound.m_128362_("OwnerUUID", this.ownerUniqueId);
        }
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    protected void m_8097_() {
    }
}

