/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.misc;

import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsBannerPatternRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.ai.navigation.navigation.PiratNavigation;
import com.github.alexthe666.rats.server.entity.monster.Pirat;
import com.github.alexthe666.rats.server.entity.projectile.CheeseCannonball;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class PiratBoat
extends Mob {
    private static final EntityDataAccessor<Boolean> FIRING = SynchedEntityData.m_135353_(PiratBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final ItemStack banner = this.generateBanner();
    private final float[] paddlePositions = new float[2];
    private boolean prevFire;
    private int fireCooldown = 0;
    public Boat.Status status;
    public Boat.Status oldStatus;
    private double waterLevel;
    private float landFriction;
    private double lastYd;

    public PiratBoat(EntityType<? extends Mob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WALKABLE, -1.0f);
        this.f_21342_ = new BoatMoveControl(this);
        this.f_21344_ = new PiratNavigation(this, this.m_9236_());
    }

    private ItemStack generateBanner() {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42728_);
        CompoundTag tag = itemstack.m_41698_("BlockEntityTag");
        ListTag list = new BannerPattern.Builder().m_222705_(RatsBannerPatternRegistry.RAT_AND_CROSSBONES_BANNER.getKey(), DyeColor.WHITE).m_58587_();
        tag.m_128365_("Patterns", (Tag)list);
        return itemstack;
    }

    protected boolean m_8091_() {
        return true;
    }

    protected boolean m_8028_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public LivingEntity m_6688_() {
        if (!this.m_20197_().isEmpty()) {
            for (Entity entity : this.m_20197_()) {
                if (!(entity instanceof Pirat)) continue;
                Pirat pirat = (Pirat)entity;
                return pirat;
            }
        }
        return null;
    }

    public void sinkInFluid(FluidType type) {
    }

    public boolean m_6040_() {
        return true;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        float radius = 0.25f;
        float angle = (float)Math.PI / 180 * this.m_146908_();
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        callback.m_20372_(passenger, this.m_20185_() - extraX, this.m_20186_() + 0.3, this.m_20189_() - extraZ);
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            living.f_20883_ = this.m_146908_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.oldStatus = this.status;
        this.status = this.getStatus();
        this.floatBoat();
    }

    public void m_8107_() {
        super.m_8107_();
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState()) {
                int n = i;
                this.paddlePositions[n] = this.paddlePositions[n] + 0.3926991f;
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        if (this.prevFire != this.isFiring()) {
            this.fireCooldown = 4;
        }
        if (this.isFiring() && this.fireCooldown == 0) {
            this.setFiring(false);
        }
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
        this.prevFire = this.isFiring();
    }

    public boolean getPaddleState() {
        return this.m_6688_() != null && this.m_20069_() && this.f_267362_.m_267780_() && this.f_20916_ <= 0;
    }

    public float getRowingTime(int side, float limbSwing) {
        return (float)Mth.m_14085_((double)((double)this.paddlePositions[side] - 0.39), (double)this.paddlePositions[side], (double)limbSwing);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FIRING, (Object)false);
    }

    public boolean isFiring() {
        return (Boolean)this.m_20088_().m_135370_(FIRING);
    }

    public void setFiring(boolean firing) {
        this.m_20088_().m_135381_(FIRING, (Object)firing);
    }

    protected void m_5841_() {
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12630_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12601_;
    }

    public void shoot(LivingEntity target, Pirat owner) {
        CheeseCannonball cannonball = new CheeseCannonball((EntityType<? extends ThrowableProjectile>)((EntityType)RatlantisEntityRegistry.CHEESE_CANNONBALL.get()), this.m_9236_(), (LivingEntity)owner);
        float radius = 1.6f;
        float angle = (float)Math.PI / 180 * this.m_146908_();
        double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + this.m_20185_();
        double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + this.m_20189_();
        double d0 = target.m_20185_() - extraX;
        double d1 = target.m_20186_() - cannonball.m_20186_();
        double d2 = target.m_20189_() - extraZ;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        cannonball.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.1f, 1.0f);
        this.m_5496_((SoundEvent)RatsSoundRegistry.PIRAT_SHOOT.get(), 3.0f, 2.3f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)cannonball);
        this.setFiring(true);
    }

    public Boat.Status getStatus() {
        Boat.Status boat$status = this.isUnderwater();
        if (boat$status != null) {
            this.waterLevel = this.m_20191_().f_82292_;
            return boat$status;
        }
        if (this.checkInWater()) {
            return Boat.Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = f;
            return Boat.Status.ON_LAND;
        }
        return Boat.Status.IN_AIR;
    }

    @Nullable
    private Boat.Status isUnderwater() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_192917_((Fluid)Fluids.f_76193_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Boat.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Boat.Status.UNDER_WATER : null;
    }

    private boolean checkInWater() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_192917_((Fluid)Fluids.f_76193_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    public void floatBoat() {
        double d1 = this.m_20068_() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        float invFriction = 0.05f;
        if (this.oldStatus == Boat.Status.IN_AIR && this.status != Boat.Status.IN_AIR && this.status != Boat.Status.ON_LAND) {
            this.waterLevel = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.getWaterLevelAbove() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Boat.Status.IN_WATER;
        } else {
            if (this.status == Boat.Status.IN_WATER || this.status == Boat.Status.UNDER_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                invFriction = 0.9f;
            } else if (this.status == Boat.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                invFriction = 0.9f;
            } else if (this.status == Boat.Status.IN_AIR) {
                invFriction = 0.9f;
            } else if (this.status == Boat.Status.ON_LAND) {
                invFriction = this.landFriction;
                if (this.m_6688_() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_ * (double)invFriction, vec3.f_82480_ + d1, vec3.f_82481_ * (double)invFriction);
            if (d2 > 0.0) {
                Vec3 vec31 = this.m_20184_();
                this.m_20334_(vec31.f_82479_, vec31.f_82480_ + d2 * 0.1, vec31.f_82481_);
            }
        }
    }

    public float getWaterLevelAbove() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)(aabb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (fluidstate.m_192917_((Fluid)Fluids.f_76193_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutableblockpos.m_123342_() + f;
        }
        return l + 1;
    }

    public float getGroundFriction() {
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.m_9236_(), (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private static class BoatMoveControl
    extends MoveControl {
        private final PiratBoat boat;

        private BoatMoveControl(PiratBoat boat) {
            super((Mob)boat);
            this.boat = boat;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.boat.m_21573_().m_26571_()) {
                double d2;
                double d1;
                double d0 = this.f_24975_ - this.boat.m_20185_();
                double d3 = Math.sqrt(d0 * d0 + (d1 = this.f_24976_ - this.boat.m_20186_()) * d1 + (d2 = this.f_24977_ - this.boat.m_20189_()) * d2);
                if (d3 < (double)1.0E-5f) {
                    this.f_24974_.m_7910_(0.0f);
                } else {
                    d1 /= d3;
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.boat.m_146922_(this.m_24991_(this.boat.m_146908_(), f, 90.0f));
                    this.boat.f_20883_ = this.boat.m_146908_();
                    float f1 = 0.5f;
                    this.boat.m_7910_(Mth.m_14179_((float)0.125f, (float)this.boat.m_6113_(), (float)f1));
                    this.boat.m_20256_(this.boat.m_20184_().m_82520_(0.0, (double)this.boat.m_6113_() * d1 * 0.1, 0.0));
                }
            } else {
                this.boat.m_7910_(0.0f);
            }
        }
    }
}

