/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster;

import com.github.alexthe666.rats.data.ratlantis.tags.RatlantisBlockTags;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class GhostPirat
extends AbstractRat
implements Enemy {
    public GhostPirat(EntityType<? extends AbstractRat> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public static boolean checkGhostPiratSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return GhostPirat.canSpawnAtPos(world, pos) || reason == MobSpawnType.SPAWNER;
    }

    private static boolean canSpawnAtPos(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_204336_(RatlantisBlockTags.PIRAT_ONLY_BLOCKS);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    protected boolean m_8028_() {
        return true;
    }

    public double m_6049_() {
        return 0.45;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(level, difficulty, reason, data, tag);
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RatlantisItemRegistry.GHOST_PIRAT_CUTLASS.get()));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RatlantisItemRegistry.GHOST_PIRAT_HAT.get()));
        return data;
    }

    public boolean m_21824_() {
        return false;
    }
}

