/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster;

import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.PiratWanderGoal;
import com.github.alexthe666.rats.server.entity.ai.navigation.navigation.PiratNavigation;
import com.github.alexthe666.rats.server.entity.misc.PiratBoat;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class Pirat
extends AbstractRat
implements RangedAttackMob,
Enemy {
    private final RangedAttackGoal fireCannonballGoal = new RangedAttackGoal((RangedAttackMob)this, 1.0, 32, 70, 16.0f);
    private final MeleeAttackGoal meleeAttackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.45, false);
    private int attackCooldown = 70;

    public Pirat(EntityType<? extends AbstractRat> type, Level level) {
        super(type, level);
        Arrays.fill(this.f_21348_, 0.1f);
        Arrays.fill(this.f_21347_, 0.1f);
        this.f_21344_ = new PiratNavigation((Mob)this, this.m_9236_());
        this.setCombatTask();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PiratWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.66));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public void setCombatTask() {
        if (!this.m_9236_().m_5776_()) {
            this.f_21345_.m_25363_((Goal)this.meleeAttackGoal);
            this.f_21345_.m_25363_((Goal)this.fireCannonballGoal);
            if (this.m_20159_()) {
                this.f_21345_.m_25352_(1, (Goal)this.fireCannonballGoal);
            } else {
                this.f_21345_.m_25352_(1, (Goal)this.meleeAttackGoal);
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (!this.m_20159_() && this.f_21344_ instanceof PiratNavigation) {
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
        }
    }

    public double m_6049_() {
        return 0.3;
    }

    @Override
    public boolean isHoldingItemInHands() {
        return true;
    }

    protected boolean m_8028_() {
        return true;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCombatTask();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, difficulty, type, data, tag);
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RatlantisItemRegistry.PIRAT_CUTLASS.get()));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RatsItemRegistry.PIRAT_HAT.get()));
        if (!this.m_20159_()) {
            PiratBoat boat = new PiratBoat((EntityType<? extends Mob>)((EntityType)RatlantisEntityRegistry.PIRAT_BOAT.get()), this.m_9236_());
            boat.m_20359_((Entity)this);
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7967_((Entity)boat);
            }
            this.m_7998_((Entity)boat, true);
        }
        this.setCombatTask();
        return data;
    }

    @Override
    public boolean m_5545_(LevelAccessor level, MobSpawnType reason) {
        return true;
    }

    public boolean m_6914_(LevelReader reader) {
        return reader.m_45784_((Entity)this);
    }

    public static boolean checkPiratSpawnRules(EntityType<Pirat> type, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean flag = accessor.m_46791_() != Difficulty.PEACEFUL;
        boolean blockIsWater = accessor.m_8055_(pos).m_60713_(Blocks.f_49990_);
        boolean blockAboveIsAir = accessor.m_8055_(pos.m_7494_()).m_60795_();
        return random.m_188503_(150) == 0 && flag && blockIsWater && blockAboveIsAir;
    }

    public boolean m_21824_() {
        return false;
    }

    public boolean m_7998_(Entity entity, boolean force) {
        boolean flag = super.m_7998_(entity, force);
        this.setCombatTask();
        return flag;
    }

    public void m_8127_() {
        super.m_8127_();
        this.setCombatTask();
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        Entity entity = this.m_20202_();
        if (entity instanceof PiratBoat) {
            PiratBoat boat = (PiratBoat)entity;
            boat.m_146870_();
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.attackCooldown == 0) {
            this.m_21391_((Entity)target, 180.0f, 180.0f);
            double d0 = target.m_20185_() - this.m_20185_();
            double d2 = target.m_20189_() - this.m_20189_();
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.m_146922_(f % 360.0f);
            this.f_20883_ = this.m_146908_();
            if (this.m_20202_() != null && this.m_20202_() instanceof PiratBoat) {
                ((PiratBoat)this.m_20202_()).shoot(target, this);
            }
            this.attackCooldown = 70;
        }
    }
}

