/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.projectile.RatlanteanFlame;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class RatlanteanSpirit
extends Monster
implements IAnimatedEntity {
    public static final Animation ANIMATION_ATTACK = Animation.create((int)10);
    private int animationTick;
    private Animation currentAnimation;

    public RatlanteanSpirit(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21342_ = new AIMoveControl(this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AIFireballAttack(this));
        this.f_21345_.m_25352_(8, (Goal)new AIMoveRandom());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22284_, 0.0);
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        super.m_6478_(type, pos);
        this.m_20101_();
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.m_9236_().m_5776_() && this.m_9236_().m_45930_((Entity)this, 64.0) != null) {
            this.m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.RAT_GHOST.get(), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), (double)0.92f, 0.82, 0.0);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK};
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)RatsSoundRegistry.RATLANTEAN_SPIRIT_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)RatsSoundRegistry.RATLANTEAN_SPIRIT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.RATLANTEAN_SPIRIT_DIE.get();
    }

    public static boolean checkSpiritSpawnRules(EntityType<? extends Mob> entity, LevelAccessor accessor, MobSpawnType type, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.m_7495_();
        return type == MobSpawnType.SPAWNER || accessor.m_8055_(blockpos).m_60643_((BlockGetter)accessor, blockpos, entity) && random.m_188503_(5) == 0;
    }

    class AIMoveControl
    extends MoveControl {
        public AIMoveControl(RatlanteanSpirit vex) {
            super((Mob)vex);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                double edgeLength;
                Vec3 vec3d = new Vec3(this.m_25000_() - RatlanteanSpirit.this.m_20185_(), this.m_25001_() - RatlanteanSpirit.this.m_20186_(), this.m_25002_() - RatlanteanSpirit.this.m_20189_());
                double d0 = vec3d.m_82553_();
                if (d0 < (edgeLength = RatlanteanSpirit.this.m_20191_().m_82309_())) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    RatlanteanSpirit.this.m_20256_(RatlanteanSpirit.this.m_20184_().m_82490_(0.5));
                } else {
                    RatlanteanSpirit.this.m_20256_(RatlanteanSpirit.this.m_20184_().m_82549_(vec3d.m_82490_(this.f_24978_ * 0.1 / d0)));
                    if (RatlanteanSpirit.this.m_5448_() == null) {
                        Vec3 vec3d1 = RatlanteanSpirit.this.m_20184_();
                        RatlanteanSpirit.this.m_146922_(-((float)Mth.m_14136_((double)vec3d1.f_82479_, (double)vec3d1.f_82481_)) * 57.295776f);
                        RatlanteanSpirit.this.f_20883_ = RatlanteanSpirit.this.m_146908_();
                    } else {
                        double d4 = RatlanteanSpirit.this.m_5448_().m_20185_() - RatlanteanSpirit.this.m_20185_();
                        double d5 = RatlanteanSpirit.this.m_5448_().m_20189_() - RatlanteanSpirit.this.m_20189_();
                        RatlanteanSpirit.this.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                        RatlanteanSpirit.this.f_20883_ = RatlanteanSpirit.this.m_146908_();
                    }
                }
            }
        }
    }

    class AIFireballAttack
    extends Goal {
        private final RatlanteanSpirit parentEntity;
        public int attackTimer;

        public AIFireballAttack(RatlanteanSpirit ghast) {
            this.parentEntity = ghast;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8037_() {
            LivingEntity living = this.parentEntity.m_5448_();
            if (living.m_20280_((Entity)this.parentEntity) >= 4096.0 || !this.parentEntity.m_142582_((Entity)living)) {
                RatlanteanSpirit.this.m_21566_().m_6849_(living.m_20185_(), living.m_20186_(), living.m_20189_(), 0.5);
            }
            if (living.m_20280_((Entity)this.parentEntity) < 4096.0) {
                Level level = this.parentEntity.m_9236_();
                ++this.attackTimer;
                if (this.attackTimer == 20) {
                    Vec3 vec3 = this.parentEntity.m_20252_(1.0f);
                    double d2 = living.m_20185_() - (this.parentEntity.m_20185_() + vec3.f_82479_ * 4.0);
                    double d3 = living.m_20227_(0.5) - (0.5 + this.parentEntity.m_20227_(0.5));
                    double d4 = living.m_20189_() - (this.parentEntity.m_20189_() + vec3.f_82481_ * 4.0);
                    RatlanteanFlame flame = new RatlanteanFlame(level, (LivingEntity)this.parentEntity, d2, d3, d4);
                    flame.m_6034_(this.parentEntity.m_20185_() + vec3.f_82479_ * 4.0, this.parentEntity.m_20227_(0.5) + 0.5, flame.m_20189_() + vec3.f_82481_ * 4.0);
                    level.m_7967_((Entity)flame);
                    this.attackTimer = -10;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }

    class AIMoveRandom
    extends Goal {
        public AIMoveRandom() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !RatlanteanSpirit.this.m_21566_().m_24995_() && RatlanteanSpirit.this.m_217043_().m_188503_(2) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = RatlanteanSpirit.this.m_20183_();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(RatlanteanSpirit.this.m_217043_().m_188503_(15) - 7, RatlanteanSpirit.this.m_217043_().m_188503_(11) - 5, RatlanteanSpirit.this.m_217043_().m_188503_(15) - 7);
                if (!RatlanteanSpirit.this.m_9236_().m_46859_(blockpos1)) continue;
                RatlanteanSpirit.this.m_21566_().m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (RatlanteanSpirit.this.m_5448_() != null) break;
                RatlanteanSpirit.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

