/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster.boss;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.projectile.DutchratSword;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Dutchrat
extends Monster
implements IAnimatedEntity {
    private int animationTick;
    private boolean useRangedAttack = false;
    private int ticksSinceThrownSword = 0;
    private Animation currentAnimation;
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    public static final Animation ANIMATION_STAB = Animation.create((int)17);
    public static final Animation ANIMATION_THROW = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    private static final EntityDataAccessor<Boolean> THROWN_SWORD = SynchedEntityData.m_135353_(Dutchrat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BELL_SPAWN_TICKS = SynchedEntityData.m_135353_(Dutchrat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);

    public Dutchrat(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21364_ = 60;
        this.f_21342_ = new DutchratMoveControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 10.0);
    }

    protected void m_8024_() {
        if (this.getBellSummonTicks() > 0) {
            if (!this.m_9236_().m_8055_(this.m_21534_()).m_60713_((Block)RatlantisBlockRegistry.DUTCHRAT_BELL.get())) {
                this.m_146870_();
            }
            int k1 = this.getBellSummonTicks() - 1;
            this.bossInfo.m_142711_(1.0f - (float)k1 / 160.0f);
            this.m_20088_().m_135381_(BELL_SPAWN_TICKS, (Object)k1);
        } else {
            super.m_8024_();
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SummonedByBellGoal());
        this.f_21345_.m_25352_(1, (Goal)new FollowTargetGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomlyMoveGoal());
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, false, false){

            public boolean m_8045_() {
                return super.m_8045_() && Dutchrat.this.m_5448_() != null && Dutchrat.this.m_21444_(Dutchrat.this.m_5448_().m_20183_()) && Dutchrat.this.getBellSummonTicks() <= 0;
            }
        });
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(THROWN_SWORD, (Object)false);
        this.m_20088_().m_135372_(BELL_SPAWN_TICKS, (Object)0);
    }

    public void setThrownSword(boolean sword) {
        this.m_20088_().m_135381_(THROWN_SWORD, (Object)sword);
    }

    public boolean hasThrownSword() {
        return (Boolean)this.m_20088_().m_135370_(THROWN_SWORD);
    }

    public void setBellSummoned() {
        this.m_20088_().m_135381_(BELL_SPAWN_TICKS, (Object)160);
    }

    public int getBellSummonTicks() {
        return (Integer)this.m_20088_().m_135370_(BELL_SPAWN_TICKS);
    }

    public boolean m_6072_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        this.f_19794_ = true;
        if (this.getAnimation() == ANIMATION_THROW && this.getAnimationTick() > 7) {
            if (!this.hasThrownSword() && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_())) {
                float bodyFacingAngle = this.f_20883_ * (float)Math.PI / 180.0f;
                double sx = this.m_20185_() + (double)(Mth.m_14089_((float)bodyFacingAngle) * 1.0f);
                double sy = this.m_20186_() + (double)this.m_20206_() * 0.82;
                double sz = this.m_20189_() + (double)(Mth.m_14031_((float)bodyFacingAngle) * 1.0f);
                double tx = this.m_5448_().m_20185_() - sx;
                double ty = this.m_5448_().m_20191_().f_82289_ + (double)(this.m_5448_().m_20206_() / 2.0f) - (this.m_20186_() + (double)(this.m_20206_() / 2.0f));
                double tz = this.m_5448_().m_20189_() - sz;
                DutchratSword sword = new DutchratSword((EntityType<? extends ThrowableProjectile>)((EntityType)RatlantisEntityRegistry.DUTCHRAT_SWORD.get()), this.m_9236_(), (LivingEntity)this);
                sword.m_6686_(tx, ty, tz, 1.75f, 1.0f);
                sword.m_7678_(sx, sy, sz, this.m_146908_(), this.m_146909_());
                this.m_9236_().m_7967_((Entity)sword);
                this.useRangedAttack = false;
            }
            this.setThrownSword(true);
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.hasThrownSword()) {
                ++this.ticksSinceThrownSword;
            }
            if (this.ticksSinceThrownSword > 100) {
                this.setThrownSword(false);
                this.ticksSinceThrownSword = 0;
            }
        }
        if (this.useRangedAttack && this.getAnimation() != ANIMATION_THROW && !this.hasThrownSword() && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_())) {
            this.setAnimation(ANIMATION_THROW);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 80.0f);
        }
        if (!this.useRangedAttack && this.m_5448_() != null && !this.hasThrownSword() && this.m_20270_((Entity)this.m_5448_()) < 7.0f && this.m_142582_((Entity)this.m_5448_())) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_SLASH : ANIMATION_STAB);
            }
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_SLASH && (this.getAnimationTick() == 10 || this.getAnimationTick() == 20)) {
                this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                this.m_5448_().m_147240_(1.5, this.m_20185_() - this.m_5448_().m_20185_(), this.m_20189_() - this.m_5448_().m_20189_());
                boolean bl = this.useRangedAttack = this.m_217043_().m_188503_(RatConfig.dutchratSwordThrowChance) == 0;
            }
            if (this.getAnimation() == ANIMATION_STAB && this.getAnimationTick() == 10) {
                this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                this.m_5448_().m_147240_(1.5, this.m_5448_().m_20185_() - this.m_20185_(), this.m_5448_().m_20189_() - this.m_20189_());
                this.useRangedAttack = this.m_217043_().m_188503_(RatConfig.dutchratSwordThrowChance) == 0;
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.getBellSummonTicks() <= 0) {
            if (this.m_21536_()) {
                this.m_9236_().m_46597_(this.m_21534_(), ((Block)RatlantisBlockRegistry.DUTCHRAT_BELL.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, difficulty, type, data, tag);
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)RatlantisItemRegistry.GHOST_PIRAT_CUTLASS.get()));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RatlantisItemRegistry.GHOST_PIRAT_HAT.get()));
        if (type != MobSpawnType.MOB_SUMMONED) {
            this.m_21446_(this.m_20183_(), RatConfig.dutchratRestrictionRadius);
        }
        return data;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getBellSummonTicks() > 0 && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268415_) || super.m_6673_(source);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SLASH, ANIMATION_STAB, ANIMATION_THROW, ANIMATION_SPEAK};
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.m_21534_() != BlockPos.f_121853_) {
            BlockPos home = this.m_21534_();
            tag.m_128365_("Home", (Tag)this.makeDoubleList(home.m_123341_(), home.m_123342_(), home.m_123343_()));
        }
        tag.m_128405_("Invul", this.getBellSummonTicks());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        if (tag.m_128425_("Home", 9)) {
            ListTag nbttaglist = tag.m_128437_("Home", 6);
            int hx = (int)nbttaglist.m_128772_(0);
            int hy = (int)nbttaglist.m_128772_(1);
            int hz = (int)nbttaglist.m_128772_(2);
            this.m_21446_(new BlockPos(hx, hy, hz), RatConfig.dutchratRestrictionRadius);
        }
        this.m_20088_().m_135381_(BELL_SPAWN_TICKS, (Object)tag.m_128451_("Invul"));
    }

    private ListTag makeDoubleList(double ... pNumbers) {
        ListTag listtag = new ListTag();
        for (double d0 : pNumbers) {
            listtag.add((Object)DoubleTag.m_128500_((double)d0));
        }
        return listtag;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8032_() {
        if (!this.m_9236_().m_5776_()) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.m_8032_();
        }
    }

    protected void m_6677_(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION && !this.m_9236_().m_5776_()) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_6677_(source);
    }

    protected SoundEvent m_7515_() {
        return this.getBellSummonTicks() > 0 ? null : (SoundEvent)RatsSoundRegistry.DUTCHRAT_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)RatsSoundRegistry.DUTCHRAT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.DUTCHRAT_DIE.get();
    }

    public boolean m_21444_(BlockPos pos) {
        if (this.m_21535_() == -1.0f) {
            return true;
        }
        int distX = Math.abs(this.m_21534_().m_123341_() - pos.m_123341_());
        int distY = Math.abs(this.m_21534_().m_123342_() - pos.m_123342_());
        int distZ = Math.abs(this.m_21534_().m_123343_() - pos.m_123343_());
        return distX <= 20 && distY <= 10 && distZ <= 20;
    }

    class DutchratMoveControl
    extends MoveControl {
        public DutchratMoveControl(Dutchrat dutchrat) {
            super((Mob)dutchrat);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                double edgeLength;
                Vec3 vec3d = new Vec3(this.m_25000_() - Dutchrat.this.m_20185_(), this.m_25001_() - Dutchrat.this.m_20186_(), this.m_25002_() - Dutchrat.this.m_20189_());
                double d0 = vec3d.m_82553_();
                if (d0 < (edgeLength = Dutchrat.this.m_20191_().m_82309_())) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    Dutchrat.this.m_20256_(Dutchrat.this.m_20184_().m_82490_(0.5));
                } else {
                    Dutchrat.this.m_20256_(Dutchrat.this.m_20184_().m_82549_(vec3d.m_82490_(this.f_24978_ * 0.1 / d0)));
                    if (Dutchrat.this.m_5448_() == null) {
                        Vec3 vec3d1 = Dutchrat.this.m_20184_();
                        Dutchrat.this.m_146922_(-((float)Mth.m_14136_((double)vec3d1.m_7096_(), (double)vec3d1.m_7094_())) * 57.295776f);
                    } else {
                        double d4 = Dutchrat.this.m_5448_().m_20185_() - Dutchrat.this.m_20185_();
                        double d5 = Dutchrat.this.m_5448_().m_20189_() - Dutchrat.this.m_20189_();
                        Dutchrat.this.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                    }
                    Dutchrat.this.f_20883_ = Dutchrat.this.m_146908_();
                }
            }
        }
    }

    class SummonedByBellGoal
    extends Goal {
        public SummonedByBellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Dutchrat.this.getBellSummonTicks() > 0;
        }
    }

    class FollowTargetGoal
    extends Goal {
        private final Dutchrat dutchrat;
        private double followDist;

        public FollowTargetGoal(Dutchrat dutchrat) {
            this.dutchrat = dutchrat;
        }

        public boolean m_8036_() {
            this.followDist = Dutchrat.this.m_20191_().m_82309_();
            LivingEntity living = this.dutchrat.m_5448_();
            double maxFollow = this.dutchrat.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            return Dutchrat.this.getBellSummonTicks() <= 0 && living != null && Dutchrat.this.m_21444_(living.m_20183_()) && ((double)living.m_20270_((Entity)this.dutchrat) >= maxFollow || !this.dutchrat.m_142582_((Entity)living));
        }

        public void m_8037_() {
            double maxFollow;
            LivingEntity living = this.dutchrat.m_5448_();
            double d = maxFollow = this.dutchrat.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            if (living != null && ((double)living.m_20270_((Entity)this.dutchrat) >= maxFollow || !this.dutchrat.m_142582_((Entity)living))) {
                if (Dutchrat.this.hasThrownSword()) {
                    BlockPos blockpos = Dutchrat.this.m_20183_();
                    if (Dutchrat.this.m_21536_()) {
                        blockpos = Dutchrat.this.m_21534_();
                    }
                    BlockPos blockpos1 = blockpos.m_7918_(Dutchrat.this.m_217043_().m_188503_(6) - 12, 0, Dutchrat.this.m_217043_().m_188503_(6) - 12);
                    Dutchrat.this.m_21566_().m_6849_((double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_(), 1.0);
                } else {
                    Dutchrat.this.m_21566_().m_6849_(living.m_20185_(), living.m_20186_() + 4.0, living.m_20189_(), 1.0);
                }
            }
        }
    }

    class RandomlyMoveGoal
    extends Goal {
        public RandomlyMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Dutchrat.this.getBellSummonTicks() <= 0 && !Dutchrat.this.m_21566_().m_24995_() && Dutchrat.this.m_217043_().m_188503_(2) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = Dutchrat.this.m_20183_();
            if (Dutchrat.this.m_21536_()) {
                blockpos = Dutchrat.this.m_21534_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(Dutchrat.this.m_217043_().m_188503_(15) - 7, Math.min(Dutchrat.this.m_217043_().m_188503_(10) - 5, 10), Dutchrat.this.m_217043_().m_188503_(15) - 7);
                if (!Dutchrat.this.m_9236_().m_46859_(blockpos1)) continue;
                Dutchrat.this.m_21566_().m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 1.0);
                if (Dutchrat.this.m_5448_() != null) break;
                Dutchrat.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

