/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.rat;

import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class DemonRat
extends AbstractRat
implements Enemy {
    public static final EntityDataAccessor<Boolean> SOUL_VARIANT = SynchedEntityData.m_135353_(DemonRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public DemonRat(EntityType<? extends AbstractRat> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SOUL_VARIANT, (Object)false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    public static boolean canDemonRatSpawnOn(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.m_7495_();
        return level.m_46791_() != Difficulty.PEACEFUL && !level.m_8055_(blockpos).m_60713_(Blocks.f_50451_) && level.m_8055_(blockpos).m_60643_((BlockGetter)level, pos, type) || reason == MobSpawnType.SPAWNER;
    }

    @Override
    public boolean m_5545_(LevelAccessor accessor, MobSpawnType type) {
        if (type == MobSpawnType.EVENT || type == MobSpawnType.SPAWNER) {
            return super.m_5545_(accessor, type);
        }
        return accessor.m_213780_().m_188503_(5) == 0;
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean m_7327_(Entity entity) {
        if (this.m_217043_().m_188503_(3) == 0) {
            entity.m_20254_(5);
        }
        return super.m_7327_(entity);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().m_5776_() && this.m_217043_().m_188501_() < 0.15f) {
            double d2 = this.m_217043_().m_188583_() * 0.0075;
            double d0 = this.m_217043_().m_188583_() * 0.0075;
            double d1 = this.m_217043_().m_188583_() * 0.0075;
            this.m_9236_().m_7106_((ParticleOptions)(this.isSoulVariant() ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), d0, d1, d2);
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("SoulVariant", this.isSoulVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSoulVariant(tag.m_128471_("SoulVariant"));
    }

    protected boolean m_8028_() {
        return true;
    }

    public double m_6049_() {
        return 0.25;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, difficulty, type, data, tag);
        this.setSoulVariant(accessor.m_204166_(this.m_20183_()).m_203565_(Biomes.f_48199_) || accessor.m_213780_().m_188503_(100) == 0);
        return data;
    }

    public boolean isSoulVariant() {
        return (Boolean)this.m_20088_().m_135370_(SOUL_VARIANT);
    }

    public void setSoulVariant(boolean soul) {
        this.m_20088_().m_135381_(SOUL_VARIANT, (Object)soul);
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_21824_() {
        return false;
    }

    @Override
    public boolean isHoldingItemInHands() {
        return this.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42685_);
    }
}

