/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.rat;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.events.ForgeClientEvents;
import com.github.alexthe666.rats.data.tags.RatsItemTags;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsCapabilityRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.block.RatCageBlock;
import com.github.alexthe666.rats.server.block.RatTubeBlock;
import com.github.alexthe666.rats.server.entity.RatMount;
import com.github.alexthe666.rats.server.entity.ai.goal.RatDepositGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatFloatGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatFollowOwnerGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatHuntGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatMeleeAttackGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatOwnerHurtByTargetGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatOwnerHurtTargetGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatPatrolGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatPickupGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatStayCloseToHomeGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatTargetItemsGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatWanderGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatWorkGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.harvest.RatHarvestCropsGoal;
import com.github.alexthe666.rats.server.entity.ai.navigation.control.EtherealRatMoveControl;
import com.github.alexthe666.rats.server.entity.ai.navigation.control.RatCageMoveControl;
import com.github.alexthe666.rats.server.entity.ai.navigation.control.RatFlightMoveControl;
import com.github.alexthe666.rats.server.entity.ai.navigation.control.RatMoveControl;
import com.github.alexthe666.rats.server.entity.ai.navigation.control.RatTubeMoveControl;
import com.github.alexthe666.rats.server.entity.ai.navigation.navigation.EtherealRatNavigation;
import com.github.alexthe666.rats.server.entity.ai.navigation.navigation.RatFlightNavigation;
import com.github.alexthe666.rats.server.entity.ai.navigation.navigation.RatNavigation;
import com.github.alexthe666.rats.server.entity.mount.RatBiplaneMount;
import com.github.alexthe666.rats.server.entity.mount.RatMountBase;
import com.github.alexthe666.rats.server.entity.rat.InventoryRat;
import com.github.alexthe666.rats.server.entity.rat.RatCommand;
import com.github.alexthe666.rats.server.items.OreRatNuggetItem;
import com.github.alexthe666.rats.server.items.RatSackItem;
import com.github.alexthe666.rats.server.items.RatStaffItem;
import com.github.alexthe666.rats.server.items.upgrades.BucketRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.EnergyRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.MobFilterUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.MountRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.OreDoublingRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesAIUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.DamageImmunityUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.HoldsItemUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.PostAttackUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.StatBoostingUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import com.github.alexthe666.rats.server.message.ManageRatStaffPacket;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.SetDancingRatPacket;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.github.alexthe666.rats.server.misc.RatUtils;
import com.github.alexthe666.rats.server.misc.RatVariant;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TamedRat
extends InventoryRat {
    private static final EntityDataAccessor<Boolean> TOGA = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> VISUAL_FLAG = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DYED = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DYE_COLOR = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DANCE_MOVES = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HELD_RF = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RESPAWN_COUNTDOWN = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<GlobalPos>> PICKUP_POS = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);
    private static final EntityDataAccessor<Optional<GlobalPos>> DEPOSIT_POS = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);
    private static final EntityDataAccessor<Boolean> IS_IN_WHEEL = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> SPECIAL_DYE = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> MOUNT_RESPAWN_COOLDOWN = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(TamedRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public Direction depositFacing = Direction.UP;
    public Direction pickupFacing = Direction.UP;
    public boolean crafting = false;
    public boolean climbingTube = false;
    public int cookingProgress = 0;
    public int coinCooldown = 0;
    public int breedCooldown = 0;
    public BlockPos jukeboxPos;
    public FluidStack transportingFluid = FluidStack.EMPTY;
    private Goal harvestGoal;
    private Goal pickupGoal;
    private Goal depositGoal;
    private Goal attackGoal;
    private Goal targetGoal;
    protected int navigatorType;
    public int rangedAttackCooldown = 0;
    public int visualCooldown = 0;
    private int poopCooldown = 0;
    public int pickpocketCooldown = 0;
    public int randomEffectCooldown = 0;
    private int updateNavigationCooldown;
    public boolean isCurrentlyWorking;
    private final Multimap<Attribute, AttributeModifier> attributeChanges = HashMultimap.create();

    public TamedRat(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        Arrays.fill(this.f_21348_, 2.0f);
        Arrays.fill(this.f_21347_, 2.0f);
        this.f_21364_ = 0;
        this.updateNavigationCooldown = 100;
    }

    @Override
    public float m_274421_() {
        return 1.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22280_, 0.35).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 12.0);
    }

    @Override
    protected void m_8099_() {
        this.harvestGoal = new RatHarvestCropsGoal(this);
        this.pickupGoal = new RatPickupGoal(this, RatPickupGoal.PickupType.INVENTORY);
        this.depositGoal = new RatDepositGoal(this, RatDepositGoal.DepositType.INVENTORY);
        this.attackGoal = new RatMeleeAttackGoal(this, 1.3, true);
        this.targetGoal = new RatHuntGoal(this, true, new ArrayList<String>());
        this.f_21345_.m_25352_(0, (Goal)new RatFloatGoal(this));
        this.f_21345_.m_25352_(1, this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)new RatFollowOwnerGoal(this, 1.25, 10.0f, 3.0f));
        this.f_21345_.m_25352_(2, (Goal)new RatStayCloseToHomeGoal(this, 1.1));
        this.f_21345_.m_25352_(3, this.harvestGoal);
        this.f_21345_.m_25352_(4, this.depositGoal);
        this.f_21345_.m_25352_(5, this.pickupGoal);
        this.f_21345_.m_25352_(6, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(7, (Goal)new RatWanderGoal(this, 1.25));
        this.f_21345_.m_25352_(7, (Goal)new RatPatrolGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f){

            public boolean m_8036_() {
                return ((TamedRat)this.f_25512_).sleepProgress <= 0.0f && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return ((TamedRat)this.f_25715_).sleepProgress <= 0.0f && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(0, (Goal)new RatTargetItemsGoal(this));
        this.f_21346_.m_25352_(1, this.targetGoal);
        this.f_21346_.m_25352_(2, (Goal)new RatOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new RatOwnerHurtTargetGoal(this));
    }

    protected void setupDynamicAI() {
        AtomicReference<RatHarvestCropsGoal> newHarvest = new AtomicReference<RatHarvestCropsGoal>(new RatHarvestCropsGoal(this));
        AtomicReference<RatDepositGoal> newDeposit = new AtomicReference<RatDepositGoal>(new RatDepositGoal(this, RatDepositGoal.DepositType.INVENTORY));
        AtomicReference<RatPickupGoal> newPickup = new AtomicReference<RatPickupGoal>(new RatPickupGoal(this, RatPickupGoal.PickupType.INVENTORY));
        AtomicReference<RatMeleeAttackGoal> newAttack = new AtomicReference<RatMeleeAttackGoal>(new RatMeleeAttackGoal(this, 1.45, true));
        RatUpgradeUtils.forEachUpgrade(this, item -> item instanceof ChangesAIUpgrade, (stack, slot) -> ((ChangesAIUpgrade)stack.m_41720_()).addNewWorkGoals(this).forEach(goal -> {
            if (!(goal instanceof RatWorkGoal)) {
                throw new IllegalArgumentException("Rat Goals must implement the interface RatWorkGoal! Goal" + goal.getClass().getName() + "doesnt do this!");
            }
            RatWorkGoal workGoal = (RatWorkGoal)goal;
            switch (workGoal.getRatTaskType()) {
                case ATTACK: {
                    newAttack.set((RatMeleeAttackGoal)goal);
                    break;
                }
                case DEPOSIT: {
                    newDeposit.set((RatDepositGoal)goal);
                    break;
                }
                case PICKUP: {
                    newPickup.set((RatPickupGoal)goal);
                    break;
                }
                case HARVEST: {
                    newHarvest.set((RatHarvestCropsGoal)goal);
                }
            }
        }));
        if (!this.m_9236_().m_5776_()) {
            this.f_21345_.m_25363_(this.harvestGoal);
            this.f_21345_.m_25363_(this.depositGoal);
            this.f_21345_.m_25363_(this.pickupGoal);
            this.f_21345_.m_25363_(this.attackGoal);
            this.attackGoal = (Goal)newAttack.get();
            this.depositGoal = newDeposit.get();
            this.pickupGoal = newPickup.get();
            this.harvestGoal = newHarvest.get();
            this.f_21345_.m_25352_(1, this.attackGoal);
            this.f_21345_.m_25352_(3, this.depositGoal);
            this.f_21345_.m_25352_(4, this.pickupGoal);
            this.f_21345_.m_25352_(5, this.harvestGoal);
            this.f_21346_.m_25363_(this.targetGoal);
            ItemStack filterUpgrade = RatUpgradeUtils.getUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_MOB_FILTER.get());
            this.targetGoal = !filterUpgrade.m_41619_() ? new RatHuntGoal(this, MobFilterUpgradeItem.isWhitelist(filterUpgrade), MobFilterUpgradeItem.getSelectedMobs(filterUpgrade)) : new RatHuntGoal(this, true, new ArrayList<String>());
            this.f_21346_.m_25352_(1, this.targetGoal);
            if (this.hasFlightUpgrade()) {
                this.switchNavigator(1);
            } else if (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_AQUATIC.get())) {
                this.switchNavigator(3);
            } else if (RatUpgradeUtils.hasUpgrade(this, (Item)RatlantisItemRegistry.RAT_UPGRADE_ETHEREAL.get())) {
                this.switchNavigator(4);
            } else {
                this.switchNavigator(this.isInCage() ? 5 : (this.isInTube() ? 2 : 0));
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TOGA, (Object)false);
        this.m_20088_().m_135372_(DANCING, (Object)false);
        this.m_20088_().m_135372_(DANCE_MOVES, (Object)0);
        this.m_20088_().m_135372_(HELD_RF, (Object)0);
        this.m_20088_().m_135372_(RESPAWN_COUNTDOWN, (Object)0);
        this.m_20088_().m_135372_(VISUAL_FLAG, (Object)false);
        this.m_20088_().m_135372_(DYED, (Object)false);
        this.m_20088_().m_135372_(FLYING, (Object)false);
        this.m_20088_().m_135372_(DYE_COLOR, (Object)0);
        this.m_20088_().m_135372_(DEPOSIT_POS, Optional.empty());
        this.m_20088_().m_135372_(PICKUP_POS, Optional.empty());
        this.m_20088_().m_135372_(IS_IN_WHEEL, (Object)false);
        this.m_20088_().m_135372_(SPECIAL_DYE, (Object)"rainbow");
        this.m_20088_().m_135372_(MOUNT_RESPAWN_COOLDOWN, (Object)20);
    }

    public void switchNavigator(int type) {
        if (type == 0) {
            this.f_21342_ = new RatMoveControl(this);
            this.f_21344_ = new RatNavigation((Mob)this, this.m_9236_());
            this.navigatorType = 0;
        } else if (type == 1) {
            this.f_21342_ = new RatFlightMoveControl(this, 1.0f);
            this.f_21344_ = new RatFlightNavigation(this, this.m_9236_());
            this.navigatorType = 1;
        } else if (type == 2) {
            this.f_21342_ = new RatTubeMoveControl(this);
            this.f_21344_ = new RatNavigation((Mob)this, this.m_9236_());
            this.navigatorType = 2;
        } else if (type == 3) {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 360, 360, 10.0f, 1.0f, true);
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.navigatorType = 3;
        } else if (type == 4) {
            this.f_21342_ = new EtherealRatMoveControl(this);
            this.f_21344_ = new EtherealRatNavigation(this, this.m_9236_());
            this.navigatorType = 4;
        } else if (type == 5) {
            this.f_21342_ = new RatCageMoveControl(this);
            this.f_21344_ = new RatNavigation((Mob)this, this.m_9236_());
            this.navigatorType = 5;
        }
    }

    @Override
    public boolean isHoldingFood() {
        if (!this.getCommand().allowsEating && !RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING.get())) {
            return false;
        }
        return !this.m_21205_().m_41619_() && RatUpgradeUtils.forEachUpgradeBool(this, stack -> stack.isRatHoldingFood(this), RatUtils.isRatFood(this.m_21205_()));
    }

    @Override
    public boolean isVisuallySitting() {
        return super.isVisuallySitting() || this.isDancing();
    }

    @Override
    public boolean isHoldingItemInHands() {
        return (this.isHoldingFood() || !this.m_21205_().m_41619_() && this.cookingProgress > 0 || this.holdsItemInHandUpgrade() || this.getMBTransferRate() > 0) && this.sleepProgress <= 0.0f;
    }

    public boolean m_7327_(Entity entity) {
        boolean flag;
        Entity entity2 = this.m_20202_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            if (this.isRidingSpecialMount()) {
                return living.m_7327_(entity);
            }
        }
        if (flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)))) {
            this.m_19970_((LivingEntity)this, entity);
            this.m_21205_().m_41622_(1, (LivingEntity)this, rat -> rat.m_21166_(EquipmentSlot.MAINHAND));
            RatUpgradeUtils.forEachUpgrade(this, item -> item instanceof PostAttackUpgrade, (stack, slot) -> ((PostAttackUpgrade)stack.m_41720_()).afterHit(this, (LivingEntity)entity));
        }
        return flag;
    }

    public boolean isInCage() {
        return this.m_9236_().m_8055_(this.m_20183_()).m_60734_() instanceof RatCageBlock;
    }

    public boolean isInTube() {
        return this.m_9236_().m_8055_(this.m_20183_()).m_60734_() instanceof RatTubeBlock;
    }

    public boolean m_6147_() {
        return this.isInTube() ? this.climbingTube : super.m_6147_();
    }

    public int m_21230_() {
        return super.m_21230_() * RatConfig.ratArmorMultiplier;
    }

    @Override
    public boolean m_6785_(double dist) {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_SCULKED.get()) ? Entity.MovementEmission.SOUNDS : Entity.MovementEmission.ALL;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return type == ForgeMod.WATER_TYPE.get() && (!RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_AQUATIC.get()) || !RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_UNDERWATER.get()));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("NavCooldown", this.updateNavigationCooldown);
        tag.m_128405_("CookingProgress", this.cookingProgress);
        tag.m_128405_("BreedCooldown", this.breedCooldown);
        tag.m_128405_("CoinCooldown", this.coinCooldown);
        tag.m_128405_("PickpocketCooldown", this.pickpocketCooldown);
        tag.m_128405_("MountCooldown", this.getMountCooldown());
        tag.m_128405_("TransportingRF", this.getHeldRF());
        tag.m_128405_("RespawnCountdown", this.getRespawnCountdown());
        tag.m_128405_("Command", this.getCommandInteger());
        tag.m_128379_("VisualFlag", this.getVisualFlag());
        tag.m_128379_("Dancing", this.isDancing());
        tag.m_128379_("Toga", this.hasToga());
        tag.m_128379_("Dyed", this.isDyed());
        tag.m_128344_("DyeColor", (byte)this.getDyeColor());
        tag.m_128359_("SpecialDye", this.getSpecialDye());
        this.getDepositPos().flatMap(pos -> GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, pos).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0))).ifPresent(tag1 -> tag.m_128365_("DepositPos", tag1));
        this.getPickupPos().flatMap(pos -> GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, pos).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0))).ifPresent(tag1 -> tag.m_128365_("PickupPos", tag1));
        tag.m_128405_("RandomEffectCooldown", this.randomEffectCooldown);
        if (this.transportingFluid != null) {
            CompoundTag fluidTag = new CompoundTag();
            this.transportingFluid.writeToNBT(fluidTag);
            tag.m_128365_("TransportingFluid", (Tag)fluidTag);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        CompoundTag fluidTag;
        super.m_7378_(tag);
        this.updateNavigationCooldown = tag.m_128451_("NavCooldown");
        this.cookingProgress = tag.m_128451_("CookingProgress");
        this.breedCooldown = tag.m_128451_("BreedCooldown");
        this.coinCooldown = tag.m_128451_("CoinCooldown");
        this.pickpocketCooldown = tag.m_128451_("PickpocketCooldown");
        this.setMountCooldown(tag.m_128451_("MountCooldown"));
        this.randomEffectCooldown = tag.m_128451_("RandomEffectCooldown");
        this.setHeldRF(tag.m_128451_("TransportingRF"));
        this.setRespawnCountdown(tag.m_128451_("RespawnCountdown"));
        this.setCommandInteger(tag.m_128451_("Command"));
        this.setDancing(tag.m_128471_("Dancing"));
        this.setVisualFlag(tag.m_128471_("VisualFlag"));
        this.setToga(tag.m_128471_("Toga"));
        this.setDyed(tag.m_128471_("Dyed"));
        this.setDyeColor(tag.m_128445_("DyeColor"));
        this.setSpecialDye(tag.m_128461_("SpecialDye"));
        if (tag.m_128441_("DepositPos")) {
            this.setDepositPos(GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("DepositPos")).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0)).orElse(null));
        }
        if (tag.m_128441_("PickupPos")) {
            this.setPickupPos(GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("PickupPos")).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0)).orElse(null));
        }
        if (tag.m_128441_("DepositFacing")) {
            this.depositFacing = Direction.values()[tag.m_128451_("DepositFacing")];
        }
        if (tag.m_128441_("PickupFacing")) {
            this.pickupFacing = Direction.values()[tag.m_128451_("PickupFacing")];
        }
        if (tag.m_128441_("TransportingFluid") && !(fluidTag = tag.m_128469_("TransportingFluid")).m_128456_()) {
            this.transportingFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)fluidTag);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6162_() && this.getCommand() != RatCommand.SIT) {
            this.setCommand(RatCommand.SIT);
        }
        if (this.breedCooldown > 0) {
            --this.breedCooldown;
        }
        if (this.m_21827_() && this.m_5448_() != null) {
            this.m_6710_(null);
        }
        if (this.m_5448_() != null && this.getMountCooldown() > 0) {
            this.m_6710_(null);
        }
        if (this.getRespawnCountdown() > 0) {
            if (this.m_9236_().m_5776_() && this.f_19797_ % 5 == 0) {
                double d0 = this.m_20182_().m_7096_();
                double d1 = this.m_20182_().m_7098_() + 0.25;
                double d2 = this.m_20182_().m_7094_();
                double d3 = ((double)this.m_217043_().m_188501_() - 0.5) * 0.15;
                double d4 = ((double)this.m_217043_().m_188501_() - 0.5) * 0.15;
                double d5 = ((double)this.m_217043_().m_188501_() - 0.5) * 0.15;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, d0, d1, d2, d3, d4, d5);
            }
            this.setRespawnCountdown(this.getRespawnCountdown() - 1);
        }
        this.m_21557_(this.getRespawnCountdown() > 0);
        if (!this.m_9236_().m_5776_() && this.getMountEntityType() != null && !this.m_20159_() && this.getMountCooldown() == 0) {
            Entity entity = this.getMountEntityType().m_20615_(this.m_9236_());
            entity.m_20359_((Entity)this);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                Level level = this.m_9236_();
                if (level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor accessor = (ServerLevelAccessor)level;
                    ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)accessor, (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                }
            }
            this.m_9236_().m_7967_(entity);
            this.m_9236_().m_7605_((Entity)this, (byte)127);
            this.m_7998_(entity, true);
        }
        RatUpgradeUtils.forEachUpgrade(this, item -> item instanceof TickRatUpgrade, (stack, slot) -> ((TickRatUpgrade)stack.m_41720_()).tick(this));
        if (RatConfig.upgradeRegenRate > 0) {
            RatUpgradeUtils.forEachUpgrade(this, item -> item instanceof StatBoostingUpgrade, (stack, slot) -> {
                if (((StatBoostingUpgrade)stack.m_41720_()).regeneratesHealth() && this.m_21223_() < this.m_21233_() && this.f_19797_ % RatConfig.upgradeRegenRate == 0) {
                    this.m_5634_(1.0f);
                }
            });
        }
        if (this.updateNavigationCooldown-- == 0) {
            this.updateNavigationCooldown = 60;
            int savedNav = this.navigatorType;
            if (this.isInCage()) {
                this.switchNavigator(5);
            } else if (this.isInTube()) {
                this.switchNavigator(2);
            } else if (this.hasFlightUpgrade()) {
                this.switchNavigator(1);
            } else {
                this.switchNavigator(savedNav);
            }
        }
        this.m_20242_(this.isFlying());
        if (this.isFlying()) {
            if (this.m_21827_() || this.f_201939_ || this.m_20096_()) {
                this.setFlying(false);
            }
            if (Math.abs(this.m_20184_().m_7096_()) < 0.01 && Math.abs(this.m_20184_().m_7094_()) < 0.01 && Math.abs(this.m_20184_().m_7098_()) > 0.0) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.1, 1.0));
            }
        }
        if (this.isInWheel() && !this.m_9236_().m_8055_(this.m_20183_()).m_60713_((Block)RatsBlockRegistry.RAT_CAGE_WHEEL.get())) {
            this.setInWheel(false);
        }
        if (this.getMountCooldown() > 0) {
            this.setMountCooldown(this.getMountCooldown() - 1);
        }
        if (this.rangedAttackCooldown > 0) {
            --this.rangedAttackCooldown;
        }
        if (this.visualCooldown > 0) {
            --this.visualCooldown;
        }
        if (this.poopCooldown > 0) {
            --this.poopCooldown;
        }
        if (this.isDancing() && this.getAnimation() != this.getDanceAnimation()) {
            this.setAnimation(this.getDanceAnimation());
        }
        if (this.isDancing() && (this.jukeboxPos == null || this.jukeboxPos.m_203198_(this.m_20185_(), this.m_20186_(), this.m_20189_()) > 256.0 || !this.m_9236_().m_8055_(this.jukeboxPos).m_60713_(Blocks.f_50131_))) {
            this.setDancing(false);
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_8055_(this.m_20183_()).m_60713_((Block)RatsBlockRegistry.RAT_QUARRY_PLATFORM.get()) && this.m_9236_().m_46859_(this.m_20183_().m_7494_())) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
            this.m_21573_().m_26573_();
        }
        if (this.f_20899_ && !this.m_9236_().m_5776_() && this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_60713_((Block)RatsBlockRegistry.RAT_QUARRY_PLATFORM.get()) && this.m_9236_().m_46859_(this.m_20183_().m_6630_(2))) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
            this.m_21573_().m_26573_();
        }
    }

    public boolean m_5825_() {
        return this.getRespawnCountdown() > 0 || super.m_5825_();
    }

    public boolean isPushedByFluid(FluidType type) {
        return !RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_QUARRY.get()) && !RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_AQUATIC.get()) && super.isPushedByFluid(type);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag;
        if (this.m_6162_() || this.m_6673_(source) || source.m_276093_(DamageTypes.f_268612_) && this.m_20159_()) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        if ((flag = super.m_6469_(source, amount)) && this.m_20202_() != null && this.isRidingSpecialMount()) {
            this.m_20202_().m_6469_(source, amount);
            this.f_19802_ = 20;
            return false;
        }
        return flag;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType((EntityType)((EntityType)RatsEntityRegistry.RAT.get())));
    }

    public void setFlying(boolean flying) {
        this.m_20088_().m_135381_(FLYING, (Object)flying);
    }

    public boolean isFlying() {
        return (Boolean)this.m_20088_().m_135370_(FLYING);
    }

    public void setToga(boolean toga) {
        this.m_20088_().m_135381_(TOGA, (Object)toga);
    }

    public boolean hasToga() {
        return (Boolean)this.m_20088_().m_135370_(TOGA);
    }

    public boolean getVisualFlag() {
        return (Boolean)this.m_20088_().m_135370_(VISUAL_FLAG);
    }

    public void setVisualFlag(boolean flag) {
        this.m_20088_().m_135381_(VISUAL_FLAG, (Object)flag);
    }

    public boolean isDancing() {
        return (Boolean)this.m_20088_().m_135370_(DANCING);
    }

    public void setDancing(boolean dancing) {
        this.m_20088_().m_135381_(DANCING, (Object)dancing);
    }

    public int getDanceMoves() {
        return (Integer)this.m_20088_().m_135370_(DANCE_MOVES);
    }

    public void setDanceMoves(int moves) {
        this.m_20088_().m_135381_(DANCE_MOVES, (Object)moves);
    }

    public int getHeldRF() {
        return (Integer)this.m_20088_().m_135370_(HELD_RF);
    }

    public void setHeldRF(int rf) {
        this.m_20088_().m_135381_(HELD_RF, (Object)rf);
    }

    public int getRespawnCountdown() {
        return (Integer)this.m_20088_().m_135370_(RESPAWN_COUNTDOWN);
    }

    public void setRespawnCountdown(int respawn) {
        this.m_20088_().m_135381_(RESPAWN_COUNTDOWN, (Object)respawn);
    }

    public boolean isInWheel() {
        return (Boolean)this.m_20088_().m_135370_(IS_IN_WHEEL);
    }

    public void setInWheel(boolean wheel) {
        this.m_20088_().m_135381_(IS_IN_WHEEL, (Object)wheel);
    }

    public boolean isDyed() {
        return (Boolean)this.m_20088_().m_135370_(DYED);
    }

    public void setDyed(boolean dyed) {
        this.m_20088_().m_135381_(DYED, (Object)dyed);
    }

    public int getDyeColor() {
        return ((Byte)this.m_20088_().m_135370_(DYE_COLOR)).byteValue();
    }

    public void setDyeColor(int color) {
        this.m_20088_().m_135381_(DYE_COLOR, (Object)((byte)color));
    }

    public String getSpecialDye() {
        return (String)this.m_20088_().m_135370_(SPECIAL_DYE);
    }

    public void setSpecialDye(String keyword) {
        this.m_20088_().m_135381_(SPECIAL_DYE, (Object)keyword);
    }

    public Optional<GlobalPos> getPickupPos() {
        return (Optional)this.m_20088_().m_135370_(PICKUP_POS);
    }

    public void setPickupPos(@Nullable GlobalPos pos) {
        this.m_20088_().m_135381_(PICKUP_POS, Optional.ofNullable(pos));
    }

    public Optional<GlobalPos> getDepositPos() {
        return (Optional)this.m_20088_().m_135370_(DEPOSIT_POS);
    }

    public void setDepositPos(@Nullable GlobalPos pos) {
        this.m_20088_().m_135381_(DEPOSIT_POS, Optional.ofNullable(pos));
    }

    public int getMountCooldown() {
        return (Integer)this.m_20088_().m_135370_(MOUNT_RESPAWN_COOLDOWN);
    }

    public void setMountCooldown(int cooldown) {
        this.m_20088_().m_135381_(MOUNT_RESPAWN_COOLDOWN, (Object)cooldown);
    }

    @Override
    public void onItemEaten() {
        ItemStack handCopy = this.m_21205_().m_41777_();
        if (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING.get()) && OreDoublingRatUpgradeItem.isProcessable(this.m_9236_(), handCopy)) {
            ItemStack attemptedSmelt = handCopy.m_41777_();
            SimpleContainer container = new SimpleContainer(new ItemStack[]{attemptedSmelt});
            SmeltingRecipe recipe = this.m_9236_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)container, this.m_9236_()).orElse(null);
            if (recipe != null && !recipe.m_8043_(this.m_9236_().m_9598_()).m_41619_()) {
                attemptedSmelt = recipe.m_8043_(this.m_9236_().m_9598_()).m_41777_();
            }
            if (!attemptedSmelt.m_150930_(handCopy.m_41720_())) {
                ItemStack nugget = OreRatNuggetItem.saveResourceToNugget(attemptedSmelt).m_255036_(2);
                if (RatConfig.ratFartNoises) {
                    this.m_5496_((SoundEvent)RatsSoundRegistry.RAT_POOP.get(), 0.5f + this.m_217043_().m_188501_() * 0.5f, 1.0f + this.m_217043_().m_188501_() * 0.5f);
                }
                if (!this.m_9236_().m_5776_()) {
                    this.m_5552_(nugget, 0.0f);
                }
                this.m_21205_().m_41774_(1);
            }
        } else if (this.m_217043_().m_188501_() <= 0.05f) {
            ItemStack nugget = new ItemStack((ItemLike)RatsItemRegistry.RAT_NUGGET.get());
            if (RatConfig.ratFartNoises) {
                this.m_5496_((SoundEvent)RatsSoundRegistry.RAT_POOP.get(), 0.5f + this.m_217043_().m_188501_() * 0.5f, 1.0f + this.m_217043_().m_188501_() * 0.5f);
            }
            if (!this.m_9236_().m_5776_()) {
                this.m_5552_(nugget, 0.0f);
            }
        } else {
            this.m_21205_().m_41774_(1);
        }
    }

    public void createBabiesFrom(TamedRat mother, TamedRat father) {
        TamedRat baby = new TamedRat((EntityType<? extends TamableAnimal>)((EntityType)RatsEntityRegistry.TAMED_RAT.get()), this.m_9236_());
        baby.setMale(this.m_217043_().m_188499_());
        RatVariant babyColor = (father.getColorVariant().isBreedingExclusive() || mother.getColorVariant().isBreedingExclusive()) && this.m_217043_().m_188503_(6) == 0 ? RatVariant.getRandomBreedingExclusiveVariant(this.m_217043_()) : (this.m_217043_().m_188503_(10) == 0 ? RatVariant.getRandomVariant(this.m_217043_(), true) : (this.m_217043_().m_188499_() ? father.getColorVariant() : mother.getColorVariant()));
        baby.setColorVariant(babyColor);
        baby.m_6034_(mother.m_20185_() - 0.5 + (double)mother.m_217043_().m_188501_(), mother.m_20186_(), mother.m_20189_() - 0.5 + (double)mother.m_217043_().m_188501_());
        baby.m_146762_(-24000);
        baby.setCommand(RatCommand.SIT);
        if (mother.m_21824_()) {
            baby.m_7105_(true);
            baby.m_21816_(mother.m_21805_());
        } else if (father.m_21824_()) {
            baby.m_7105_(true);
            baby.m_21816_(father.m_21805_());
        }
        this.m_9236_().m_7967_((Entity)baby);
    }

    public boolean m_6087_() {
        return !(this.m_20202_() instanceof Player);
    }

    public ItemStack getResultForRecipe(RecipeType<? extends SingleItemRecipe> recipe, ItemStack stack) {
        ItemStack itemstack;
        Optional optional = this.m_9236_().m_7465_().m_44015_(recipe, (Container)new SimpleContainer(new ItemStack[]{stack}), this.m_9236_());
        if (optional.isPresent() && !(itemstack = ((SingleItemRecipe)optional.get()).m_8043_(this.m_9236_().m_9598_())).m_41619_()) {
            ItemStack itemstack1 = itemstack.m_41777_();
            itemstack1.m_41764_(stack.m_41613_() * itemstack.m_41613_());
            return itemstack1;
        }
        return ItemStack.f_41583_;
    }

    public boolean tryDepositItemInContainers(ItemStack burntItem) {
        LazyOptional handler;
        BlockEntity te;
        if (this.m_9236_().m_7702_(this.m_20183_()) != null && (te = this.m_9236_().m_7702_(this.m_20183_())) != null && (handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP)).resolve().isPresent() && ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.resolve().get()), (ItemStack)burntItem, (boolean)true).m_41619_()) {
            ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.resolve().get()), (ItemStack)burntItem, (boolean)false);
            return true;
        }
        return false;
    }

    protected void m_7324_(Entity entity) {
        if (!this.crafting) {
            entity.m_7334_((Entity)this);
        }
    }

    public Animation getDanceAnimation() {
        if (this.getDanceMoves() == 0) {
            return ANIMATION_DANCE;
        }
        return NO_ANIMATION;
    }

    protected void m_7472_(DamageSource source, int looting, boolean playerKill) {
        if (this.hasToga()) {
            this.m_5552_(new ItemStack((ItemLike)RatlantisItemRegistry.RAT_TOGA.get()), 0.0f);
        }
        super.m_7472_(source, looting, playerKill);
    }

    public void spawnAngelCopy() {
        TamedRat copy = (TamedRat)((EntityType)RatsEntityRegistry.TAMED_RAT.get()).m_20615_(this.m_9236_());
        CompoundTag tag = new CompoundTag();
        this.m_7380_(tag);
        tag.m_128376_("HurtTime", (short)0);
        tag.m_128405_("HurtByTimestamp", 0);
        tag.m_128376_("DeathTime", (short)0);
        copy.m_7378_(tag);
        copy.m_21153_(copy.m_21233_());
        copy.m_20359_((Entity)this);
        copy.setRespawnCountdown(1200);
        if (copy.isVisuallySitting()) {
            copy.sitProgress = 20.0f;
        }
        if (this.m_8077_()) {
            copy.m_6593_(this.m_7770_());
        }
        copy.m_20095_();
        this.m_9236_().m_7967_((Entity)copy);
    }

    public boolean m_7301_(MobEffectInstance instance) {
        if (instance.m_19544_() == MobEffects.f_19614_ && (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_POISON.get()) || RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION.get()))) {
            return false;
        }
        return super.m_7301_(instance);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.getRespawnCountdown() > 0 || itemstack.m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rats", "rat_spawn_egg")))) {
            return InteractionResult.PASS;
        }
        if (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_CARRAT.get()) && player.m_36324_().m_38721_()) {
            player.m_36324_().m_38707_(1, 0.1f);
            player.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            for (int i = 0; i < 8; ++i) {
                double d0 = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                double d2 = this.m_217043_().m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42619_)), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_() * 2.0f) - (double)this.m_20206_(), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
            }
            if (RatConfig.carratDamagePerBite > 0.0) {
                this.m_6469_(this.m_269291_().m_269075_(player), (float)RatConfig.carratDamagePerBite);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_6162_()) {
            if (itemstack.m_204117_(RatsItemTags.CHEESE_ITEMS)) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146740_(TamedRat.m_216967_((int)(-this.m_146764_())), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (itemstack.m_150930_((Item)RatsItemRegistry.CREATIVE_CHEESE.get())) {
                this.m_146740_(-(this.m_146764_() / 20), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        if (!this.m_6162_() && this.m_21830_((LivingEntity)player)) {
            if (player.m_36341_() && !this.m_20159_()) {
                if (player.m_20197_().size() < 3) {
                    this.m_7998_((Entity)player, true);
                    player.m_5661_((Component)Component.m_237115_((String)"entity.rats.rat.dismount"), true);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (itemstack.m_150930_((Item)RatsItemRegistry.RAT_PAPERS.get())) {
                InteractionResult result = itemstack.m_41647_(player, (LivingEntity)this, hand);
                if (result.m_19077_()) {
                    return result;
                }
            } else {
                if (itemstack.m_150930_((Item)RatlantisItemRegistry.RAT_TOGA.get())) {
                    if (!this.hasToga()) {
                        if (!player.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    } else if (!this.m_9236_().m_5776_()) {
                        this.m_5552_(new ItemStack((ItemLike)RatlantisItemRegistry.RAT_TOGA.get()), 0.0f);
                    }
                    this.setToga(!this.hasToga());
                    this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_150930_(((Block)RatsBlockRegistry.DYE_SPONGE.get()).m_5456_()) && this.isDyed()) {
                    this.setDyed(false);
                    this.setDyeColor(0);
                    this.setSpecialDye("");
                    for (int i = 0; i < 8; ++i) {
                        double d0 = this.m_217043_().m_188583_() * 0.02;
                        double d1 = this.m_217043_().m_188583_() * 0.02;
                        double d2 = this.m_217043_().m_188583_() * 0.02;
                        this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)RatsBlockRegistry.DYE_SPONGE.get())), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_() * 2.0f) - (double)this.m_20206_(), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
                    }
                    this.m_5496_((SoundEvent)RatsSoundRegistry.DYE_SPONGE_USED.get(), this.m_6121_(), this.m_6100_());
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_150930_((Item)RatsItemRegistry.RATBOW_ESSENCE.get()) && this.applySpecialDyeIfPossible(itemstack)) {
                    return InteractionResult.SUCCESS;
                }
                if (this.applyNormalDyeIfPossible(itemstack)) {
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_150930_((Item)RatsItemRegistry.RAT_SACK.get())) {
                    if (RatSackItem.getRatsInSack(itemstack) >= RatConfig.ratSackCapacity) {
                        player.m_5661_((Component)Component.m_237115_((String)"item.rats.rat_sack.too_full").m_130940_(ChatFormatting.RED), true);
                        return InteractionResult.PASS;
                    }
                    RatSackItem.packRatIntoSack(itemstack, this, RatSackItem.getRatsInSack(itemstack) + 1);
                    this.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
                    this.m_146870_();
                    player.m_6674_(hand);
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_41720_() instanceof RatStaffItem) {
                    player.getCapability(RatsCapabilityRegistry.SELECTED_RAT).ifPresent(cap -> cap.setSelectedRat(this));
                    player.m_6674_(hand);
                    if (!this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        RatsNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new ManageRatStaffPacket(this.m_19879_(), BlockPos.f_121853_, Direction.NORTH.ordinal(), false, false));
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"item.rats.staff.bind", (Object[])new Object[]{this.m_7755_()}), true);
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_150930_(Items.f_42412_)) {
                    itemstack.m_41774_(1);
                    ItemStack arrow = new ItemStack((ItemLike)RatsItemRegistry.RAT_ARROW.get());
                    CompoundTag tag = new CompoundTag();
                    CompoundTag ratTag = new CompoundTag();
                    this.m_7380_(ratTag);
                    if (this.m_8077_()) {
                        ratTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.m_7770_()));
                    }
                    tag.m_128365_("Rat", (Tag)ratTag);
                    arrow.m_41751_(tag);
                    if (itemstack.m_41619_()) {
                        player.m_21008_(hand, arrow);
                    } else if (!player.m_150109_().m_36054_(arrow)) {
                        player.m_36176_(arrow, false);
                    }
                    this.m_5496_((SoundEvent)RatsSoundRegistry.RAT_HURT.get(), 1.0f, 1.0f);
                    player.m_6674_(hand);
                    this.m_146870_();
                    return InteractionResult.SUCCESS;
                }
                return super.m_6071_(player, hand);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean applyNormalDyeIfPossible(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem item2 = (DyeItem)item;
            if (!this.isDyed() || this.getDyeColor() != item2.m_41089_().m_41060_()) {
                if (!this.isDyed()) {
                    this.setDyed(true);
                }
                this.setDyeColor(item2.m_41089_().m_41060_());
                for (int i = 0; i < 8; ++i) {
                    double d0 = this.m_217043_().m_188583_() * 0.02;
                    double d1 = this.m_217043_().m_188583_() * 0.02;
                    double d2 = this.m_217043_().m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_() * 2.0f) - (double)this.m_20206_(), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
                }
                this.m_5496_((SoundEvent)RatsSoundRegistry.ESSENCE_APPLIED.get(), this.m_6121_(), this.m_6100_());
                stack.m_41774_(1);
                return true;
            }
        }
        return false;
    }

    public boolean applySpecialDyeIfPossible(ItemStack stack) {
        String name = stack.m_41786_().getString();
        if (!this.getSpecialDye().equals(name) || !this.isDyed()) {
            if (!this.isDyed()) {
                this.setDyed(true);
            }
            this.setDyeColor(100);
            this.setSpecialDye(name);
            for (int i = 0; i < 8; ++i) {
                double d0 = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                double d2 = this.m_217043_().m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)RatsItemRegistry.RATBOW_ESSENCE.get())), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_() * 2.0f) - (double)this.m_20206_(), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
            }
            this.m_5496_((SoundEvent)RatsSoundRegistry.ESSENCE_APPLIED.get(), this.m_6121_(), this.m_6100_());
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    public void m_7105_(boolean tamed) {
        if (tamed) {
            Arrays.fill(this.f_21348_, 1.1f);
            Arrays.fill(this.f_21347_, 1.1f);
        }
        super.m_7105_(tamed);
    }

    public int m_8100_() {
        return RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_CHRISTMAS.get()) ? 1000 : 200;
    }

    public boolean m_142535_(float dist, float mult, DamageSource source) {
        if (!this.m_6673_(source) && !this.m_20159_()) {
            return super.m_142535_(dist, mult, source);
        }
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        if (!this.hasFlightUpgrade()) {
            super.m_7840_(y, onGround, state, pos);
        }
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.updateRiding(player);
        }
    }

    public void updateRiding(Player riding) {
        int i = riding.m_20197_().indexOf((Object)this);
        float radius = (i == 0 ? 0.0f : 0.4f) + (float)(riding.m_21255_() ? 1 : 0);
        float angle = (float)Math.PI / 180 * riding.f_20883_ + (i == 2 ? -92.5f : (i == 1 ? 92.5f : 0.0f));
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double extraY = riding.m_6047_() ? 1.2 : (riding.m_21255_() ? 0.25 : 1.4);
        this.m_146922_(riding.f_20885_);
        this.f_20885_ = riding.f_20885_;
        this.f_19859_ = riding.f_20885_;
        this.m_6034_(riding.m_20185_() + extraX, riding.m_20186_() + extraY, riding.m_20189_() + extraZ);
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 85) {
            this.crafting = true;
        } else if (id == 86) {
            this.crafting = false;
        } else if (id == 127) {
            for (int k = 0; k < 20; ++k) {
                double d2 = this.m_217043_().m_188583_() * 0.02;
                double d0 = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d2, d0, d1);
            }
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    protected SoundEvent m_7515_() {
        SoundEvent possibleDragonSound;
        if (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_CHRISTMAS.get())) {
            return (SoundEvent)RatsSoundRegistry.RAT_SANTA.get();
        }
        if (RatsMod.ICEANDFIRE_LOADED && RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_DRAGON.get()) && (possibleDragonSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("iceandfire", "firedragon_child_idle"))) != null) {
            return possibleDragonSound;
        }
        return super.m_7515_();
    }

    @Override
    protected SoundEvent m_5592_() {
        SoundEvent possibleDragonSound;
        if (RatsMod.ICEANDFIRE_LOADED && RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_DRAGON.get()) && (possibleDragonSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("iceandfire", "firedragon_child_death"))) != null) {
            return possibleDragonSound;
        }
        return super.m_5592_();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        SoundEvent possibleDragonSound;
        if (RatsMod.ICEANDFIRE_LOADED && RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_DRAGON.get()) && (possibleDragonSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("iceandfire", "firedragon_child_hurt"))) != null) {
            return possibleDragonSound;
        }
        return super.m_7975_(source);
    }

    public boolean onHearFlute(Player player, RatCommand ratCommand) {
        if (this.m_21830_((LivingEntity)player) && !this.m_6162_() && !RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_NO_FLUTE.get())) {
            this.setCommand(ratCommand);
            return true;
        }
        return false;
    }

    public boolean canRatPickupItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_BLACKLIST.get()) || RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_WHITELIST.get())) {
            CompoundTag tag = RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_BLACKLIST.get()) ? RatUpgradeUtils.getUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_BLACKLIST.get()).m_41783_() : RatUpgradeUtils.getUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_WHITELIST.get()).m_41783_();
            String ourItemID = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())).toString();
            if (tag != null && tag.m_128425_("Items", 9)) {
                ListTag list = tag.m_128437_("Items", 10);
                if (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_BLACKLIST.get())) {
                    for (int i = 0; i < list.size(); ++i) {
                        String itemID = list.m_128728_(i).m_128461_("id");
                        if (!ourItemID.equals(itemID)) continue;
                        return false;
                    }
                    return true;
                }
                for (int i = 0; i < list.size(); ++i) {
                    String itemID = list.m_128728_(i).m_128461_("id");
                    if (!ourItemID.equals(itemID)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public MobType m_6336_() {
        if (this.getInventory() != null) {
            if (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_UNDEAD.get())) {
                return MobType.f_21641_;
            }
            if (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_AQUATIC.get())) {
                return MobType.f_21644_;
            }
        }
        return super.m_6336_();
    }

    public boolean m_6094_() {
        return !this.m_6162_() && super.m_6094_();
    }

    public boolean m_142038_() {
        if (this.m_9236_().m_5776_() && ForgeClientEvents.isRatSelectedOnStaff(this)) {
            return true;
        }
        return super.m_142038_();
    }

    public void attemptTeleport(double x, double y, double z) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        this.m_6034_(x, y, z);
        this.m_9236_().m_7605_((Entity)this, (byte)84);
        boolean flag = false;
        BlockPos blockpos = this.m_20183_();
        if (this.m_9236_().m_46749_(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.m_123342_() > 0) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState state = this.m_9236_().m_8055_(blockpos1);
                if (state.m_280555_()) {
                    flag1 = true;
                    continue;
                }
                this.m_6034_(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
                blockpos = blockpos1;
            }
            if (flag1) {
                this.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                if (this.m_9236_().m_45786_((Entity)this) && !this.m_9236_().m_46855_(this.m_20191_())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.m_6021_(d0, d1, d2);
        } else {
            this.m_5496_((SoundEvent)RatsSoundRegistry.RAT_TELEPORT.get(), 1.0f, 1.0f);
        }
    }

    public boolean isDirectPathBetweenPoints(Vec3 target) {
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockPos pos = result.m_82425_();
        BlockPos sidePos = result.m_82425_().m_121945_(result.m_82434_());
        if (!this.m_9236_().m_46859_(pos) || !this.m_9236_().m_46859_(sidePos)) {
            return true;
        }
        return result.m_6662_() == HitResult.Type.MISS;
    }

    public boolean m_142066_() {
        return !RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_UNDEAD.get()) && super.m_142066_();
    }

    public boolean m_21525_() {
        return super.m_21525_() || this.getRespawnCountdown() > 0;
    }

    public boolean holdsItemInHandUpgrade() {
        boolean bool = RatUpgradeUtils.forEachUpgradeBool(this, stack -> {
            HoldsItemUpgrade upgrade;
            return stack instanceof HoldsItemUpgrade && !(upgrade = (HoldsItemUpgrade)((Object)stack)).isFakeHandRender();
        }, false);
        return !this.isInWheel() && bool;
    }

    @Override
    public boolean shouldPlayIdleAnimations() {
        boolean bool = RatUpgradeUtils.forEachUpgradeBool(this, stack -> stack.playIdleAnimation(this), true);
        return super.shouldPlayIdleAnimations() && !this.isInTube() && !this.isInWheel() && this.cookingProgress <= 0 && bool;
    }

    public boolean hasAnyUpgrades() {
        for (EquipmentSlot slot : RatUpgradeUtils.UPGRADE_SLOTS) {
            if (this.m_6844_(slot).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDigThroughBlocks() {
        return false;
    }

    public void onUpgradeChanged() {
        RatMount mount;
        this.setupDynamicAI();
        Entity vehicle = this.m_20202_();
        if (!this.m_9236_().m_5776_() && vehicle instanceof RatMount && !RatUpgradeUtils.hasUpgrade(this, (mount = (RatMount)vehicle).getUpgradeItem())) {
            this.m_9236_().m_7605_((Entity)this, (byte)127);
            this.m_8127_();
            vehicle.m_146870_();
        }
        if (!this.attributeChanges.isEmpty()) {
            this.m_21204_().m_22161_(this.attributeChanges);
            this.attributeChanges.clear();
        }
        RatUpgradeUtils.forEachUpgrade(this, item -> item instanceof StatBoostingUpgrade, (stack, slot) -> ((StatBoostingUpgrade)stack.m_41720_()).getAttributeBoosts().forEach((attribute, aDouble) -> this.tryIncreaseStat(stack.m_41786_().getString(), (Attribute)attribute, (double)aDouble)));
        if (this.getHeldRF() > this.getRFTransferRate()) {
            this.setHeldRF(this.getRFTransferRate());
        }
        this.m_5634_(this.m_21233_());
        this.setFlying(this.isFlying() && this.hasFlightUpgrade());
        this.m_20242_(RatUpgradeUtils.hasUpgrade(this, (Item)RatlantisItemRegistry.RAT_UPGRADE_ETHEREAL.get()) || this.isFlying());
    }

    public void tryIncreaseStat(String itemName, Attribute stat, double value) {
        AttributeModifier modifier = new AttributeModifier(itemName + " " + Component.m_237115_((String)stat.m_22087_()).getString() + " Modifier", value, AttributeModifier.Operation.ADDITION);
        Objects.requireNonNull(this.m_21051_(stat)).m_22118_(modifier);
        this.attributeChanges.put((Object)stat, (Object)modifier);
    }

    public boolean m_6673_(DamageSource source) {
        if (this.getRespawnCountdown() > 0) {
            return true;
        }
        AtomicBoolean upgradePrevented = new AtomicBoolean(false);
        RatUpgradeUtils.forEachUpgrade(this, item -> item instanceof DamageImmunityUpgrade, (stack, slot) -> {
            if (((DamageImmunityUpgrade)stack.m_41720_()).isImmuneToDamageSource(this, source)) {
                upgradePrevented.set(true);
            }
        });
        if (RatUpgradeUtils.hasUpgrade(this, (Item)RatsItemRegistry.RAT_UPGRADE_CREATIVE.get())) {
            LivingEntity living;
            Entity entity;
            return source.m_7639_() == null || (entity = source.m_7639_()) instanceof LivingEntity && !this.m_21830_(living = (LivingEntity)entity);
        }
        return upgradePrevented.get() || super.m_6673_(source);
    }

    public boolean m_20147_() {
        return super.m_20147_() || this.getRespawnCountdown() > 0;
    }

    public void m_6818_(BlockPos pos, boolean partying) {
        int moves = this.m_217043_().m_188503_(4);
        if (!this.isDancing() && partying) {
            this.setDanceMoves(moves);
        }
        this.setDancing(partying);
        this.jukeboxPos = pos;
        if (this.m_9236_().m_5776_()) {
            RatsNetworkHandler.CHANNEL.sendToServer((Object)new SetDancingRatPacket(this.m_19879_(), partying, pos.m_121878_(), moves));
        }
    }

    public boolean shouldDepositItem(ItemStack item) {
        return RatUpgradeUtils.forEachUpgradeBool(this, stack -> stack.shouldDepositItem(this, item), true);
    }

    public boolean shouldCollectItem(ItemStack item) {
        return RatUpgradeUtils.forEachUpgradeBool(this, stack -> stack.shouldCollectItem(this, item), true);
    }

    public int getRFTransferRate() {
        AtomicInteger energy = new AtomicInteger();
        RatUpgradeUtils.forEachUpgrade(this, item -> item instanceof EnergyRatUpgradeItem, (stack, slot) -> energy.set(((EnergyRatUpgradeItem)stack.m_41720_()).getRFTransferRate()));
        return energy.get();
    }

    public int getMBTransferRate() {
        AtomicInteger fluid = new AtomicInteger();
        RatUpgradeUtils.forEachUpgrade(this, item -> item instanceof BucketRatUpgradeItem, (stack, slot) -> fluid.set(((BucketRatUpgradeItem)stack.m_41720_()).getMbTransferRate()));
        return fluid.get();
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingentity = this.m_269323_();
        if (entity == livingentity) {
            return true;
        }
        if (entity instanceof RatMountBase) {
            RatMountBase mount = (RatMountBase)entity;
            return mount.getRat() != null && this.m_7307_((Entity)mount.getRat());
        }
        if (livingentity != null && entity instanceof TamableAnimal) {
            TamableAnimal animal = (TamableAnimal)entity;
            return animal.m_21830_(livingentity);
        }
        return livingentity != null ? livingentity.m_7307_(entity) : super.m_7307_(entity);
    }

    @Nullable
    public EntityType<?> getMountEntityType() {
        AtomicReference<Object> type = new AtomicReference<Object>(null);
        RatUpgradeUtils.forEachUpgrade(this, item -> item instanceof MountRatUpgradeItem, (stack, slot) -> type.set(((MountRatUpgradeItem)stack.m_41720_()).getEntityType()));
        return type.get();
    }

    public double getRatDistanceCenterSq(double x, double y, double z) {
        double d0 = this.m_20185_() - x - 0.5;
        double d1 = this.m_20186_() - y - 0.5;
        double d2 = this.m_20189_() - z - 0.5;
        if (this.m_20202_() != null && this.getMountEntityType() != null && this.m_20202_().m_6095_() == this.getMountEntityType()) {
            d0 = this.m_20202_().m_20185_() - x - 0.5;
            d1 = this.m_20202_().m_20186_() - y - 0.5;
            d2 = this.m_20202_().m_20189_() - z - 0.5;
        }
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double getRatDistanceSq(double x, double y, double z) {
        double d0 = this.m_20185_() - x;
        double d1 = this.m_20186_() - y;
        double d2 = this.m_20189_() - z;
        if (this.m_20202_() != null && this.getMountEntityType() != null && this.m_20202_().m_6095_() == this.getMountEntityType()) {
            d0 = this.m_20202_().m_20185_() - x;
            d1 = this.m_20202_().m_20186_() - y;
            d2 = this.m_20202_().m_20189_() - z;
        }
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double m_20238_(Vec3 vec) {
        double d0 = this.m_20185_() - vec.m_7096_();
        double d1 = this.m_20186_() - vec.m_7098_();
        double d2 = this.m_20189_() - vec.m_7094_();
        if (this.m_20202_() != null && this.getMountEntityType() != null && this.m_20202_().m_6095_() == this.getMountEntityType()) {
            d0 = this.m_20202_().m_20185_() - vec.m_7096_();
            d1 = this.m_20202_().m_20186_() - vec.m_7098_();
            d2 = this.m_20202_().m_20189_() - vec.m_7094_();
        }
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public boolean isRidingSpecialMount() {
        boolean ret = false;
        if (this.m_20202_() != null && this.getMountEntityType() != null) {
            ret = this.m_20202_().m_6095_().equals(this.getMountEntityType());
        }
        return ret;
    }

    public boolean m_6779_(LivingEntity target) {
        return !this.isRidingSpecialMount() || !RatUtils.isRidingOrBeingRiddenBy((Entity)this, (Entity)target);
    }

    public double getRatHarvestDistance(double expansion) {
        return (3.5 + expansion) * this.getRatDistanceModifier();
    }

    public double getRatDistanceModifier() {
        Entity entity;
        if (this.isRidingSpecialMount() && (entity = this.m_20202_()) != null) {
            if (entity instanceof RatBiplaneMount) {
                return 3.95;
            }
            return 1.5;
        }
        return 1.0;
    }

    public boolean hasFlightUpgrade() {
        return RatUpgradeUtils.forEachUpgradeBool(this, stack -> stack.canFly(this), false);
    }
}

