/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.client.model.RatsModelLayers;
import com.github.alexthe666.rats.client.model.hats.ArcheologistHatModel;
import com.github.alexthe666.rats.client.model.hats.AviatorHatModel;
import com.github.alexthe666.rats.client.model.hats.ChefToqueModel;
import com.github.alexthe666.rats.client.model.hats.CrownModel;
import com.github.alexthe666.rats.client.model.hats.ExterminatorHatModel;
import com.github.alexthe666.rats.client.model.hats.FarmerHatModel;
import com.github.alexthe666.rats.client.model.hats.GhostPiratHatModel;
import com.github.alexthe666.rats.client.model.hats.HaloHatModel;
import com.github.alexthe666.rats.client.model.hats.MilitaryHatModel;
import com.github.alexthe666.rats.client.model.hats.PiperHatModel;
import com.github.alexthe666.rats.client.model.hats.PiratHatModel;
import com.github.alexthe666.rats.client.model.hats.PlagueDoctorMaskModel;
import com.github.alexthe666.rats.client.model.hats.RatFezModel;
import com.github.alexthe666.rats.client.model.hats.SantaHatModel;
import com.github.alexthe666.rats.client.model.hats.TopHatModel;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.monster.GhostPirat;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HatItem
extends ArmorItem {
    private final int loreLines;

    public HatItem(Item.Properties properties, ArmorMaterial material, int loreLines) {
        super(material, ArmorItem.Type.HELMET, properties);
        this.loreLines = loreLines;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_150930_((Item)RatsItemRegistry.BLACK_DEATH_MASK.get())) {
            tooltip.add((Component)Component.m_237115_((String)"item.rats.plague_doctor_mask.desc").m_130940_(ChatFormatting.GRAY));
        }
        if (this.loreLines > 0) {
            for (int i = 0; i < this.loreLines; ++i) {
                tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc" + (Serializable)(this.loreLines == 1 ? "" : Integer.valueOf(i)))).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.m_150930_((Item)RatsItemRegistry.RAT_KING_CROWN.get());
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan enderMan) {
        return stack.m_150930_((Item)RatsItemRegistry.BLACK_DEATH_MASK.get()) || stack.m_150930_((Item)RatsItemRegistry.PLAGUE_DOCTOR_MASK.get());
    }

    public void transformOnHead(AbstractRat rat, PoseStack stack) {
        if (this == RatsItemRegistry.CHEF_TOQUE.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(25.0f));
            stack.m_252880_(0.0f, 0.1f, 0.3f);
        }
        if (this == RatsItemRegistry.PIPER_HAT.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(10.0f));
            stack.m_252880_(0.0f, 0.0f, 0.1f);
        }
        if (this == RatsItemRegistry.PIRAT_HAT.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
            stack.m_252880_(0.0f, -0.125f, 0.0f);
            stack.m_85841_(1.425f, 1.425f, 1.425f);
        }
        if (this == RatlantisItemRegistry.GHOST_PIRAT_HAT.get()) {
            float piratScale = rat instanceof GhostPirat ? 1.1f : 1.425f;
            float piratTranslate = rat instanceof GhostPirat ? 0.05f : -0.125f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.3f);
            stack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
            stack.m_252880_(0.0f, piratTranslate, 0.0f);
            stack.m_85841_(piratScale, piratScale, piratScale);
        }
        if (this == RatsItemRegistry.ARCHEOLOGIST_HAT.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
            stack.m_252880_(0.0f, -0.1f, 0.0f);
            stack.m_85841_(1.425f, 1.425f, 1.425f);
        }
        if (this == RatsItemRegistry.FARMER_HAT.get() || this == RatsItemRegistry.FISHERMAN_HAT.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
            stack.m_252880_(0.0f, -0.1f, 0.0f);
            stack.m_85841_(1.425f, 1.425f, 1.425f);
        }
        if (this == RatsItemRegistry.PLAGUE_DOCTOR_MASK.get() || this == RatsItemRegistry.BLACK_DEATH_MASK.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(15.0f));
            stack.m_252880_(0.0f, -0.1f, 0.0f);
            stack.m_85841_(1.5f, 1.2f, 1.5f);
        }
        if (this == RatsItemRegistry.RAT_FEZ.get()) {
            stack.m_252880_(-0.05f, -0.15f, -0.1f);
            stack.m_85841_(1.425f, 1.425f, 1.425f);
        }
        if (this == RatsItemRegistry.TOP_HAT.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
            stack.m_252880_(0.0f, -0.125f, 0.0f);
            stack.m_85841_(1.425f, 1.425f, 1.425f);
        }
        if (this == RatsItemRegistry.SANTA_HAT.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
            stack.m_252880_(0.0f, 0.0f, 0.1f);
            stack.m_85841_(1.25f, 1.25f, 1.25f);
        }
        if (this == RatlantisItemRegistry.MILITARY_HAT.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
            stack.m_252880_(0.0f, -0.1f, 0.0f);
            stack.m_85841_(1.425f, 1.425f, 1.425f);
        }
        if (this == RatsItemRegistry.RAT_KING_CROWN.get()) {
            stack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
            stack.m_252880_(0.0f, -0.05f, 0.0f);
            stack.m_85841_(1.25f, 1.25f, 1.25f);
        }
        if (this == RatlantisItemRegistry.AVIATOR_HAT.get()) {
            stack.m_85841_(1.25f, 1.25f, 1.25f);
            stack.m_252880_(0.0f, -0.035f, 0.01f);
        }
    }

    public float getRatOffsetOnHead() {
        if (this == RatsItemRegistry.TOP_HAT.get()) {
            return -0.85f;
        }
        if (this == RatlantisItemRegistry.MILITARY_HAT.get() || this == RatlantisItemRegistry.GHOST_PIRAT_HAT.get() || this == RatsItemRegistry.PIRAT_HAT.get()) {
            return -0.45f;
        }
        return 0.0f;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String item = ForgeRegistries.ITEMS.getKey((Object)this).m_135815_();
        if (!item.equals("air")) {
            return new ResourceLocation("rats", "textures/model/hat/" + item + ".png").toString();
        }
        return "textures/particle/flea_0.png";
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return switch (ForgeRegistries.ITEMS.getKey((Object)HatItem.this).m_135815_()) {
                    case "chef_toque" -> new ChefToqueModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.CHEF_TOQUE));
                    case "piper_hat" -> new PiperHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.PIPER_HAT));
                    case "archeologist_hat" -> new ArcheologistHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.ARCHEOLOGIST_HAT));
                    case "farmer_hat", "fisherman_hat" -> new FarmerHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.FARMER_HAT));
                    case "rat_fez" -> new RatFezModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.FEZ));
                    case "top_hat" -> new TopHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.TOP_HAT));
                    case "santa_hat" -> new SantaHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.SANTA_HAT));
                    case "halo_hat" -> new HaloHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.HALO));
                    case "pirat_hat" -> new PiratHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.PIRATE_HAT));
                    case "rat_king_crown" -> new CrownModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.CROWN));
                    case "plague_doctor_mask", "black_death_mask" -> new PlagueDoctorMaskModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.PLAGUE_DOCTOR_MASK));
                    case "exterminator_hat" -> new ExterminatorHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.EXTERMINATOR_HAT));
                    case "aviator_hat" -> new AviatorHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.AVIATOR_HAT));
                    case "ghost_pirat_hat" -> new GhostPiratHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.PIRATE_HAT));
                    case "military_hat" -> new MilitaryHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.OFFICER_HAT));
                    default -> original;
                };
            }
        });
    }
}

