/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class OreRatNuggetItem
extends Item {
    public OreRatNuggetItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)RatsSoundRegistry.RAT_NUGGET_ORE.get(), SoundSource.PLAYERS, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        ItemStack poopStack = OreRatNuggetItem.getStoredItem(itemstack, new ItemStack((ItemLike)Items.f_42416_));
        if (!player.m_150109_().m_36054_(poopStack)) {
            player.m_36176_(poopStack, false);
        }
        if (!player.m_7500_()) {
            itemstack.m_41774_(1);
        }
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public static ItemStack getStoredItem(ItemStack poopItem, ItemStack fallback) {
        if (poopItem.m_41784_().m_128441_("OreItem")) {
            CompoundTag poopTag = poopItem.m_41784_().m_128469_("OreItem");
            ItemStack oreItem = ItemStack.m_41712_((CompoundTag)poopTag);
            if (oreItem.m_41619_()) {
                return fallback;
            }
            return oreItem;
        }
        return fallback;
    }

    public static ItemStack getIngot(Level level, ItemStack stack) {
        SimpleContainer container = new SimpleContainer(new ItemStack[]{stack});
        SmeltingRecipe recipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)container, level).orElse(null);
        if (recipe != null && !recipe.m_8043_(level.m_9598_()).m_41619_()) {
            return recipe.m_8043_(level.m_9598_()).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack saveResourceToNugget(ItemStack resource) {
        ItemStack stack = new ItemStack((ItemLike)RatsItemRegistry.RAT_NUGGET_ORE.get());
        CompoundTag nuggetTag = new CompoundTag();
        CompoundTag oreTag = new CompoundTag();
        resource.m_41739_(oreTag);
        nuggetTag.m_128365_("OreItem", (Tag)oreTag);
        stack.m_41751_(nuggetTag);
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (flag.m_257552_()) {
            ItemStack ingot = OreRatNuggetItem.getStoredItem(stack, new ItemStack((ItemLike)Items.f_41852_));
            tooltip.add((Component)Component.m_237110_((String)"item.rats.ore_nugget.contains", (Object[])new Object[]{ingot.m_41611_().getString()}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_nugget_ore.desc").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }
}

