/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsRecipeRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.level.block.Block;

public class ArcheologistRatUpgradeItem
extends BaseRatUpgradeItem
implements TickRatUpgrade {
    public ArcheologistRatUpgradeItem(Item.Properties properties) {
        super(properties, 2, 1);
    }

    @Override
    public boolean isRatHoldingFood(TamedRat rat) {
        return false;
    }

    @Override
    public boolean shouldDepositItem(TamedRat rat, ItemStack stack) {
        return rat.getResultForRecipe((RecipeType<? extends SingleItemRecipe>)((RecipeType)RatsRecipeRegistry.ARCHEOLOGIST.get()), stack).m_41619_();
    }

    @Override
    public void tick(TamedRat rat) {
        if (!rat.m_21205_().m_41619_()) {
            this.tryArcheology(rat);
            this.createFinishedParticles(rat, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)RatsBlockRegistry.GARBAGE_PILE.get()).m_49966_()), 1, (ParticleOptions)ParticleTypes.f_123809_, 0.125f);
        }
    }

    private void tryArcheology(TamedRat rat) {
        ItemStack heldItem = rat.m_21205_();
        ItemStack burntItem = rat.getResultForRecipe((RecipeType<? extends SingleItemRecipe>)((RecipeType)RatsRecipeRegistry.ARCHEOLOGIST.get()), heldItem.m_255036_(1));
        if (burntItem.m_41619_()) {
            rat.cookingProgress = 0;
        } else {
            ++rat.cookingProgress;
            if (rat.cookingProgress == 100) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    rat.m_21008_(InteractionHand.MAIN_HAND, burntItem);
                } else if (!rat.tryDepositItemInContainers(burntItem) && !rat.m_9236_().m_5776_()) {
                    rat.m_5552_(burntItem, 0.25f);
                }
                rat.cookingProgress = 0;
            }
        }
    }
}

