/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseFlightRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesTextureUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.PostAttackUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import com.github.alexthe666.rats.server.misc.RatUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BeeRatUpgradeItem
extends BaseFlightRatUpgradeItem
implements ChangesTextureUpgrade,
PostAttackUpgrade,
TickRatUpgrade {
    public BeeRatUpgradeItem(Item.Properties properties) {
        super(properties, 1, 3);
    }

    @Override
    public ItemStack getWing() {
        return new ItemStack((ItemLike)RatsItemRegistry.FEATHERY_WING.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("rats", "textures/entity/rat/upgrades/bee.png");
    }

    @Override
    public boolean makesEyesGlowByDefault() {
        return false;
    }

    @Override
    public void afterHit(TamedRat rat, LivingEntity target) {
        target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 1200, 1));
    }

    @Override
    public void tick(TamedRat rat) {
        if (rat.randomEffectCooldown == 0) {
            rat.randomEffectCooldown = 500 + rat.m_217043_().m_188503_(500);
            if (rat.m_217043_().m_188503_(3) == 0) {
                RatUtils.polinateAround(rat.m_9236_(), rat.m_20183_());
            }
        }
    }
}

