/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.loot;

import com.github.alexthe666.rats.registry.RatsLootRegistry;
import com.github.alexthe666.rats.server.entity.mount.RatMountBase;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.ForgeRegistries;

public record RatKilledAndHasUpgradeCondition(Item upgrade) implements LootItemCondition
{
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)RatsLootRegistry.KILLER_HAS_UPGRADE.get();
    }

    public boolean test(LootContext context) {
        TamedRat rat;
        if (!context.m_78936_(LootContextParams.f_81458_)) {
            return false;
        }
        Object object = context.m_165124_(LootContextParams.f_81458_);
        if (object instanceof RatMountBase) {
            RatMountBase base = (RatMountBase)object;
            return base.getRat() != null && RatUpgradeUtils.hasUpgrade(base.getRat(), this.upgrade());
        }
        object = context.m_165124_(LootContextParams.f_81458_);
        return object instanceof TamedRat && RatUpgradeUtils.hasUpgrade(rat = (TamedRat)((Object)object), this.upgrade());
    }

    public static LootItemCondition.Builder hasUpgrade(Item upgrade) {
        return () -> new RatKilledAndHasUpgradeCondition(upgrade);
    }

    public static class RatSerializer
    implements Serializer<RatKilledAndHasUpgradeCondition> {
        public void serialize(JsonObject object, RatKilledAndHasUpgradeCondition condition, JsonSerializationContext context) {
            object.addProperty("upgrade", ForgeRegistries.ITEMS.getKey((Object)condition.upgrade()).toString());
        }

        public RatKilledAndHasUpgradeCondition deserialize(JsonObject object, JsonDeserializationContext context) {
            try {
                Item upgrade = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)object, (String)"upgrade")));
                return new RatKilledAndHasUpgradeCondition(upgrade);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

