/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record SetDancingRatPacket(int ratId, boolean setDancing, long blockPos, int moves) {
    public static SetDancingRatPacket decode(FriendlyByteBuf buf) {
        return new SetDancingRatPacket(buf.readInt(), buf.readBoolean(), buf.readLong(), buf.readInt());
    }

    public static void encode(SetDancingRatPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.ratId());
        buf.writeBoolean(packet.setDancing());
        buf.writeLong(packet.blockPos());
        buf.writeInt(packet.moves());
    }

    public static class Handler {
        public static void handle(SetDancingRatPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(packet.ratId())) instanceof TamedRat) {
                    TamedRat rat = (TamedRat)entity;
                    if (!rat.isDancing() && packet.setDancing()) {
                        rat.setDanceMoves(packet.moves());
                    }
                    rat.setDancing(packet.setDancing());
                    rat.jukeboxPos = BlockPos.m_122022_((long)packet.blockPos());
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

