/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.block.entity.AutoCurdlerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public record UpdateCurdlerFluidPacket(long blockPos, FluidStack fluid) {
    public static UpdateCurdlerFluidPacket decode(FriendlyByteBuf buf) {
        return new UpdateCurdlerFluidPacket(buf.readLong(), FluidStack.readFromPacket((FriendlyByteBuf)buf));
    }

    public static void encode(UpdateCurdlerFluidPacket packet, FriendlyByteBuf buf) {
        buf.writeLong(packet.blockPos());
        packet.fluid().writeToPacket(buf);
    }

    public static class Handler {
        public static void handle(final UpdateCurdlerFluidPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    BlockEntity blockEntity;
                    BlockPos pos = BlockPos.m_122022_((long)packet.blockPos());
                    ClientLevel level = Minecraft.m_91087_().f_91073_;
                    if (level != null && (blockEntity = level.m_7702_(pos)) instanceof AutoCurdlerBlockEntity) {
                        AutoCurdlerBlockEntity curdler = (AutoCurdlerBlockEntity)blockEntity;
                        curdler.getTank().setFluid(packet.fluid());
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

