/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.Nullable;

public class PlagueDoctorWorldData
extends SavedData {
    private static final String IDENTIFIER = "rats_world_data";
    private int doctorSpawnDelay;
    private int doctorSpawnChance;
    private UUID doctorID;

    public PlagueDoctorWorldData() {
        this.m_77762_();
    }

    @Nullable
    public static PlagueDoctorWorldData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel server = level.m_7654_().m_129880_(level.m_46472_());
            DimensionDataStorage storage = server.m_8895_();
            return (PlagueDoctorWorldData)storage.m_164861_(PlagueDoctorWorldData::read, PlagueDoctorWorldData::new, IDENTIFIER);
        }
        return null;
    }

    public int getDoctorSpawnDelay() {
        return this.doctorSpawnDelay;
    }

    public void setDoctorSpawnDelay(int delay) {
        this.doctorSpawnDelay = delay;
        this.m_77762_();
    }

    public int getDoctorSpawnChance() {
        return this.doctorSpawnChance;
    }

    public void setDoctorSpawnChance(int chance) {
        this.doctorSpawnChance = chance;
        this.m_77762_();
    }

    public void setPlagueDoctorID(UUID id) {
        this.doctorID = id;
        this.m_77762_();
    }

    public static PlagueDoctorWorldData read(CompoundTag tag) {
        PlagueDoctorWorldData data = new PlagueDoctorWorldData();
        if (tag.m_128425_("PlagueDoctorSpawnDelay", 99)) {
            data.doctorSpawnDelay = tag.m_128451_("PlagueDoctorSpawnDelay");
        }
        if (tag.m_128425_("PlagueDoctorSpawnChance", 99)) {
            data.doctorSpawnChance = tag.m_128451_("PlagueDoctorSpawnChance");
        }
        if (tag.m_128425_("PlagueDoctorId", 8)) {
            data.doctorID = UUID.fromString(tag.m_128461_("PlagueDoctorId"));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128405_("PlagueDoctorSpawnDelay", this.doctorSpawnDelay);
        compound.m_128405_("PlagueDoctorSpawnChance", this.doctorSpawnChance);
        if (this.doctorID != null) {
            compound.m_128359_("PlagueDoctorId", this.doctorID.toString());
        }
        return compound;
    }
}

