/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.craftingmanager.blocks;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsstorage.modules.craftingmanager.CraftingManagerModule;
import mcjty.rftoolsstorage.modules.craftingmanager.blocks.CraftingManagerContainer;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingQueue;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingRequest;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingSystem;
import mcjty.rftoolsstorage.modules.craftingmanager.system.ICraftingDevice;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingManagerTileEntity
extends GenericTileEntity {
    public static final ModelProperty<BlockState>[] MIMIC = new ModelProperty[]{new ModelProperty(), new ModelProperty(), new ModelProperty(), new ModelProperty()};
    @Cap(type=CapType.ITEMS)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CraftingManagerContainer.CONTAINER_FACTORY).onUpdate((slot, stack) -> {
        if (slot < 4) {
            this.markDirtyClient();
            this.devicesDirty = true;
        }
    }).build();
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Crafting Manager").containerSupplier((windowId, player) -> new CraftingManagerContainer((int)windowId, this.m_58899_(), this, (Player)player)).itemHandler(() -> (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> h).orElseThrow(RuntimeException::new)));
    private final CraftingQueue[] queues = new CraftingQueue[4];
    private boolean devicesDirty = true;
    public static final double QUALITY_NOTPOSSIBLE = -1.0;
    public static final double QUALITY_DEVICEIDLE = 10000.0;

    public CraftingManagerTileEntity(BlockPos pos, BlockState state) {
        super(CraftingManagerModule.TYPE_CRAFTING_MANAGER.get(), pos, state);
        for (int i = 0; i < 4; ++i) {
            this.queues[i] = new CraftingQueue();
        }
    }

    private Optional<ICraftingDevice> getDevice(int queueIndex) {
        if (this.devicesDirty) {
            this.updateDevices();
        }
        return Optional.ofNullable(this.queues[queueIndex].getDevice());
    }

    public boolean tick(CraftingSystem system) {
        boolean rc = false;
        for (int queueIndex = 0; queueIndex < 4; ++queueIndex) {
            int finalQueueIndex = queueIndex;
            rc = this.getDevice(queueIndex).map(device -> {
                device.tick();
                if (device.getStatus() == ICraftingDevice.Status.READY) {
                    this.sendResultsBack(finalQueueIndex, system);
                    return true;
                }
                return false;
            }).orElse(rc);
        }
        return rc;
    }

    private void sendResultsBack(int queueIndex, CraftingSystem system) {
        List output = this.getDevice(queueIndex).map(device -> device.extractOutput(this.f_58857_)).orElse(Collections.emptyList());
        StorageScannerTileEntity storage = system.getStorage();
        for (ItemStack stack : output) {
            ItemStack left = storage.insertInternal(stack, false);
            Containers.m_18992_((Level)this.f_58857_, (double)((double)storage.m_58899_().m_123341_() + 0.5), (double)((double)storage.m_58899_().m_123342_() + 1.5), (double)((double)storage.m_58899_().m_123343_() + 0.5), (ItemStack)left);
        }
    }

    public boolean canCraft(Ingredient ingredient) {
        for (int i = 4; i < this.items.getSlots(); ++i) {
            ItemStack result;
            ItemStack card = this.items.getStackInSlot(i);
            if (card.m_41619_() || !ingredient.test(result = CraftingCardItem.getResult((ItemStack)card))) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getCraftables() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 4; i < this.items.getSlots(); ++i) {
            ItemStack result;
            ItemStack card = this.items.getStackInSlot(i);
            if (card.m_41619_() || (result = CraftingCardItem.getResult((ItemStack)card)).m_41619_()) continue;
            stacks.add(result);
        }
        return stacks;
    }

    public Pair<Double, Integer> getCraftingQuality(Ingredient ingredient, int amount) {
        AtomicDouble bestQuality = new AtomicDouble(-1.0);
        AtomicInteger bestDevice = new AtomicInteger(-1);
        for (int queueIndex = 0; queueIndex < 4; ++queueIndex) {
            int finalQueueIndex = queueIndex;
            this.getDevice(queueIndex).ifPresent(device -> {
                Queue<CraftingRequest> requests = this.queues[finalQueueIndex].getRequests();
                double baseQuality = Math.max(0.0, 1.0 - (double)requests.size() / 10.0);
                switch (device.getStatus()) {
                    case IDLE: {
                        baseQuality += 10000.0;
                        break;
                    }
                    case READY: {
                        baseQuality += 0.5;
                        break;
                    }
                }
                double quality = -1.0;
                for (int i = this.getFirstCardIndex(finalQueueIndex); i < this.getLastCardIndex(finalQueueIndex); ++i) {
                    ItemStack result;
                    ItemStack card = this.items.getStackInSlot(i);
                    if (card.m_41619_() || !ingredient.test(result = CraftingCardItem.getResult((ItemStack)card))) continue;
                    quality = baseQuality;
                    break;
                }
                if (quality >= 0.0 && quality > bestQuality.get()) {
                    bestQuality.set(quality);
                    bestDevice.set(finalQueueIndex);
                }
            });
        }
        return Pair.of((Object)bestQuality.get(), (Object)bestDevice.get());
    }

    private int getLastCardIndex(int queueIndex) {
        return 4 + queueIndex * 8 + 8;
    }

    private int getFirstCardIndex(int queueIndex) {
        return 4 + queueIndex * 8;
    }

    public CraftingQueue[] getQueues() {
        return this.queues;
    }

    @Nonnull
    public List<Ingredient> getIngredients(int queueIndex, CraftingRequest request) {
        CraftingQueue queue = this.queues[queueIndex];
        if (this.devicesDirty) {
            this.updateDevices();
        }
        for (int i = this.getFirstCardIndex(queueIndex); i < this.getLastCardIndex(queueIndex); ++i) {
            ItemStack cardStack = this.items.getStackInSlot(i);
            if (cardStack.m_41619_()) continue;
            ItemStack cardResult = CraftingCardItem.getResult((ItemStack)cardStack);
            if (!request.ingredient().test(cardResult)) continue;
            queue.getDevice().setupCraft(this.f_58857_, cardStack);
            return queue.getDevice().getIngredients();
        }
        return Collections.emptyList();
    }

    public boolean startCraft(int queueIndex, CraftingRequest request, List<ItemStack> ingredients) {
        CraftingQueue queue = this.queues[queueIndex];
        if (this.devicesDirty) {
            this.updateDevices();
        }
        return queue.getDevice().insertIngredients(this.f_58857_, ingredients);
    }

    private void updateDevices() {
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            ResourceLocation id = Tools.getId((ItemStack)stack);
            ResourceLocation deviceId = CraftingManagerModule.CRAFTING_DEVICE_REGISTRY.getDeviceForBlock(id);
            if (deviceId == null) continue;
            Supplier<ICraftingDevice> device = CraftingManagerModule.CRAFTING_DEVICE_REGISTRY.getDeviceSupplier(deviceId);
            ICraftingDevice craftingDevice = device.get();
            this.queues[i].setDevice(craftingDevice);
        }
        this.devicesDirty = false;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        ItemStack origMimic0 = this.items.getStackInSlot(0);
        ItemStack origMimic1 = this.items.getStackInSlot(1);
        ItemStack origMimic2 = this.items.getStackInSlot(2);
        ItemStack origMimic3 = this.items.getStackInSlot(3);
        this.loadClientDataFromNBT(pkt.m_131708_());
        ItemStack mimic0 = this.items.getStackInSlot(0);
        ItemStack mimic1 = this.items.getStackInSlot(1);
        ItemStack mimic2 = this.items.getStackInSlot(2);
        ItemStack mimic3 = this.items.getStackInSlot(3);
        if (!(ItemStack.m_41656_((ItemStack)origMimic0, (ItemStack)mimic0) && ItemStack.m_41656_((ItemStack)origMimic1, (ItemStack)mimic1) && ItemStack.m_41656_((ItemStack)origMimic2, (ItemStack)mimic2) && ItemStack.m_41656_((ItemStack)origMimic3, (ItemStack)mimic3))) {
            this.requestModelDataUpdate();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nonnull
    public ModelData getModelData() {
        BlockState mimic0 = this.items.getStackInSlot(0).m_41619_() ? null : ((BlockItem)this.items.getStackInSlot(0).m_41720_()).m_40614_().m_49966_();
        BlockState mimic1 = this.items.getStackInSlot(1).m_41619_() ? null : ((BlockItem)this.items.getStackInSlot(1).m_41720_()).m_40614_().m_49966_();
        BlockState mimic2 = this.items.getStackInSlot(2).m_41619_() ? null : ((BlockItem)this.items.getStackInSlot(2).m_41720_()).m_40614_().m_49966_();
        BlockState mimic3 = this.items.getStackInSlot(3).m_41619_() ? null : ((BlockItem)this.items.getStackInSlot(3).m_41720_()).m_40614_().m_49966_();
        return ModelData.builder().with(MIMIC[0], (Object)mimic0).with(MIMIC[1], (Object)mimic1).with(MIMIC[2], (Object)mimic2).with(MIMIC[3], (Object)mimic3).build();
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        ListTag deviceList = tagCompound.m_128437_("devices", 10);
        int i = 0;
        for (Tag nbt : deviceList) {
            CompoundTag deviceNBT = (CompoundTag)nbt;
            if (!deviceNBT.m_128456_()) {
                ResourceLocation deviceId = new ResourceLocation(deviceNBT.m_128461_("deviceId"));
                Supplier<ICraftingDevice> deviceSupplier = CraftingManagerModule.CRAFTING_DEVICE_REGISTRY.getDeviceSupplier(deviceId);
                ICraftingDevice device = deviceSupplier.get();
                this.queues[i].setDevice(device);
                device.read(deviceNBT);
            }
            ++i;
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        ListTag deviceList = new ListTag();
        for (CraftingQueue queue : this.queues) {
            CompoundTag deviceNBT = new CompoundTag();
            if (queue.hasDevice()) {
                queue.getDevice().write(deviceNBT);
                deviceNBT.m_128359_("deviceId", queue.getDevice().getID().toString());
            }
            deviceList.add((Object)deviceNBT);
        }
        tagCompound.m_128365_("devices", (Tag)deviceList);
    }
}

