/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsstorage.modules.scanner.client.GuiStorageScanner;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public record PacketReturnInventoryInfo(List<InventoryInfo> inventories) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsstorage", "return_inventory_info");

    public List<InventoryInfo> getInventories() {
        return this.inventories;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.inventories.size());
        for (InventoryInfo info : this.inventories) {
            buf.m_130064_(info.pos());
            buf.m_130070_(info.name());
            buf.writeBoolean(info.routable());
            if (info.block() == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            String id = Tools.getId((Block)info.block()).toString();
            buf.m_130070_(id);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketReturnInventoryInfo create(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<InventoryInfo> inventories = new ArrayList<InventoryInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buf.m_130135_();
            String name = buf.m_130136_(Short.MAX_VALUE);
            boolean routable = buf.readBoolean();
            Block block = null;
            if (buf.readBoolean()) {
                block = Tools.getBlock((ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
            }
            inventories.add(new InventoryInfo(pos, name, routable, block));
        }
        return new PacketReturnInventoryInfo(inventories);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            GuiStorageScanner.fromServer_inventories = this.getInventories();
        });
    }

    public record InventoryInfo(BlockPos pos, String name, boolean routable, Block block) {
    }
}

