/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm.transformers;

import codechicken.asm.ASMBlock;
import codechicken.asm.InsnComparator;
import codechicken.asm.InsnListSection;
import codechicken.asm.ModularASMTransformer;
import codechicken.asm.ObfMapping;
import codechicken.asm.transformers.MethodTransformer;
import java.util.Set;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodReplacer
extends MethodTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodReplacer.class);
    public ASMBlock needle;
    public ASMBlock replacement;

    public MethodReplacer(@Nonnull ObfMapping method, @Nonnull ASMBlock needle, @Nonnull ASMBlock replacement) {
        super(method);
        this.needle = needle;
        this.replacement = replacement;
    }

    public MethodReplacer(@Nonnull ObfMapping method, @Nonnull InsnList needle, @Nonnull InsnList replacement) {
        this(method, new ASMBlock(needle), new ASMBlock(replacement));
    }

    @Override
    public void addMethodsToSort(Set<ObfMapping> set) {
        set.add(this.method);
    }

    @Override
    public void transform(MethodNode mv) {
        for (InsnListSection key : InsnComparator.findN(mv.instructions, this.needle.list)) {
            if (ModularASMTransformer.DEBUG) {
                LOGGER.info("Replacing method '{}' @ {} - {}.", new Object[]{this.method, key.start, key.end});
            } else {
                LOGGER.debug("Replacing method '{}' @ {} - {}.", new Object[]{this.method, key.start, key.end});
            }
            ASMBlock replaceBlock = this.replacement.copy().pullLabels(this.needle.applyLabels(key));
            key.insert(replaceBlock.list.list);
        }
    }
}

