/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.api;

import codechicken.microblock.api.MicroMaterialClient;
import codechicken.microblock.util.MicroMaterialRegistry;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public abstract class MicroMaterial {
    @Nullable
    Object renderProperties;

    public MicroMaterial() {
        this.initClient();
    }

    public ResourceLocation getRegistryName() {
        return Objects.requireNonNull(MicroMaterialRegistry.MICRO_MATERIALS.getKey((Object)this));
    }

    public abstract boolean isTransparent();

    public abstract int getLightEmission();

    public abstract float getStrength(Player var1);

    public abstract Component getLocalizedName();

    public abstract ItemStack getItem();

    @Nullable
    public abstract Tier getCutterTier();

    @Nullable
    public abstract SoundType getSound();

    public abstract float getExplosionResistance(BlockGetter var1, BlockPos var2, Explosion var3);

    public void initializeClient(Consumer<MicroMaterialClient> cons) {
    }

    private void initClient() {
        if (FMLEnvironment.dist == Dist.CLIENT && !FMLLoader.getLaunchHandler().isData()) {
            this.initializeClient(props -> {
                this.renderProperties = props;
            });
        }
    }
}

