/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.part;

import codechicken.microblock.part.MicroblockPart;
import codechicken.multipart.block.TileMultipart;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class ExecutablePlacement {
    public final BlockPos pos;
    public final MicroblockPart part;

    protected ExecutablePlacement(BlockPos pos, MicroblockPart part) {
        this.pos = pos;
        this.part = part;
    }

    public abstract void place(Level var1, Player var2, ItemStack var3);

    public abstract void consume(Level var1, Player var2, ItemStack var3);

    public static class ExpandingPlacement
    extends ExecutablePlacement {
        private final MicroblockPart oPart;

        public ExpandingPlacement(BlockPos pos, MicroblockPart nPart, MicroblockPart oPart) {
            super(pos, nPart);
            this.oPart = oPart;
        }

        @Override
        public void place(Level level, Player player, ItemStack stack) {
            this.oPart.shape = this.part.shape;
            this.oPart.tile().notifyPartChange(this.oPart);
            this.oPart.sendShapeUpdate();
        }

        @Override
        public void consume(Level level, Player player, ItemStack stack) {
            stack.m_41774_(1);
        }
    }

    public static class AdditionPlacement
    extends ExecutablePlacement {
        public AdditionPlacement(BlockPos pos, MicroblockPart part) {
            super(pos, part);
        }

        @Override
        public void place(Level level, Player player, ItemStack stack) {
            TileMultipart.addPart(level, this.pos, this.part);
        }

        @Override
        public void consume(Level level, Player player, ItemStack stack) {
            stack.m_41774_(1);
        }
    }
}

