/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.api;

import codechicken.mixin.MixinCompilerImpl;
import codechicken.mixin.api.MixinBackend;
import codechicken.mixin.api.MixinDebugger;
import codechicken.mixin.api.MixinLanguageSupport;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.MixinInfo;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

public interface MixinCompiler {
    public static MixinCompiler create() {
        return new MixinCompilerImpl();
    }

    public static MixinCompiler create(MixinBackend backend) {
        return new MixinCompilerImpl(backend);
    }

    public static MixinCompiler create(MixinBackend backend, MixinDebugger debugger) {
        return new MixinCompilerImpl(backend, debugger);
    }

    public static MixinCompiler create(MixinBackend backend, MixinDebugger debugger, Collection<Class<? extends MixinLanguageSupport>> supports) {
        return new MixinCompilerImpl(backend, debugger, () -> supports);
    }

    public MixinBackend getMixinBackend();

    @Nullable
    public <T extends MixinLanguageSupport> T getLanguageSupport(String var1);

    @Nullable
    public ClassInfo getClassInfo(String var1);

    @Nullable
    public ClassInfo getClassInfo(ClassNode var1);

    @Nullable
    default public ClassInfo getClassInfo(@Nullable Class<?> clazz) {
        return clazz == null ? null : this.getClassInfo(clazz.getName().replace(".", "/"));
    }

    @Nullable
    public ClassNode getClassNode(String var1);

    public MixinInfo registerTrait(ClassNode var1);

    @Nullable
    public MixinInfo getMixinInfo(String var1);

    public <T> Class<T> defineClass(String var1, byte[] var2);

    public <T> Class<T> getDefinedClass(String var1);

    public <T> Class<T> compileMixinClass(String var1, String var2, Set<String> var3);
}

