/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.api;

import codechicken.asm.ASMHelper;
import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.ClassNodeInfo;
import codechicken.mixin.util.JavaTraitGenerator;
import codechicken.mixin.util.MixinInfo;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

public interface MixinLanguageSupport {
    @Nullable
    public ClassInfo obtainInfo(ClassNode var1);

    @Nullable
    public MixinInfo buildMixinTrait(ClassNode var1);

    @LanguageName(value="java")
    @SortingIndex(value=0x7FFFFFFF)
    public static class JavaMixinLanguageSupport
    implements MixinLanguageSupport {
        protected final MixinCompiler mixinCompiler;
        private BiFunction<MixinCompiler, ClassNode, JavaTraitGenerator> traitGeneratorFactory = JavaTraitGenerator::new;

        public JavaMixinLanguageSupport(MixinCompiler mixinCompiler) {
            this.mixinCompiler = mixinCompiler;
        }

        public void setTraitGeneratorFactory(BiFunction<MixinCompiler, ClassNode, JavaTraitGenerator> factory) {
            this.traitGeneratorFactory = factory;
        }

        @Override
        public ClassInfo obtainInfo(ClassNode cNode) {
            return new ClassNodeInfo(this.mixinCompiler, cNode);
        }

        @Override
        public MixinInfo buildMixinTrait(ClassNode cNode) {
            JavaTraitGenerator generator = this.traitGeneratorFactory.apply(this.mixinCompiler, cNode);
            ClassNode sNode = generator.getStaticNode();
            if (sNode != null) {
                this.mixinCompiler.defineClass(sNode.name, ASMHelper.createBytes(sNode, 3));
            }
            ClassNode tNode = generator.getTraitNode();
            MixinInfo info = generator.getMixinInfo();
            this.mixinCompiler.defineClass(tNode.name, ASMHelper.createBytes(tNode, 3));
            return info;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SortingIndex {
        public int value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LanguageName {
        public String value();
    }
}

