/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.scala;

import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.api.MixinLanguageSupport;
import codechicken.mixin.scala.ScalaClassInfo;
import codechicken.mixin.scala.ScalaSignature;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.FieldMixin;
import codechicken.mixin.util.MixinInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MixinLanguageSupport.LanguageName(value="scala")
public class MixinScalaLanguageSupport
implements MixinLanguageSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MixinScalaLanguageSupport.class);
    private final MixinCompiler mixinCompiler;

    public MixinScalaLanguageSupport(MixinCompiler mixinCompiler) {
        this.mixinCompiler = mixinCompiler;
    }

    @Override
    public ClassInfo obtainInfo(ClassNode cNode) {
        ScalaClassInfo info;
        String baseName;
        ClassNode baseNode;
        if (cNode.name.endsWith("$") && (baseNode = this.mixinCompiler.getClassNode(baseName = cNode.name.substring(0, cNode.name.length() - 1))) != null && (info = this.scalaInfo(baseNode, true)) != null) {
            return info;
        }
        return this.scalaInfo(cNode, false);
    }

    @Nullable
    private ScalaClassInfo scalaInfo(ClassNode cNode, boolean obj) {
        Record cSym;
        ScalaSignature sig = ScalaSignature.parse(cNode);
        if (sig == null) {
            return null;
        }
        String name = cNode.name.replace('/', '.');
        Record record = cSym = obj ? sig.findObject(name) : sig.findClass(name);
        if (cSym == null) {
            return null;
        }
        return new ScalaClassInfo(this.mixinCompiler, cNode, sig, (ScalaSignature.ClassSymbolRef)((Object)cSym));
    }

    @Override
    public MixinInfo buildMixinTrait(ClassNode cNode) {
        ScalaClassInfo info;
        ClassInfo classInfo = this.mixinCompiler.getClassInfo(cNode);
        if (!(classInfo instanceof ScalaClassInfo) || !(info = (ScalaClassInfo)classInfo).isTrait()) {
            return null;
        }
        ScalaSignature sig = info.sig;
        Set<String> filtered = this.listFiltered(sig);
        List<MixinInfo> parentTraits = this.getAndRegisterParentTraits(cNode);
        ArrayList<FieldMixin> fields = new ArrayList<FieldMixin>();
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        ArrayList<String> supers = new ArrayList<String>();
        ScalaSignature.ClassSymbolRef cSym = info.cSym;
        for (ScalaSignature.MethodSymbol sym : sig.collect(8)) {
            LOGGER.debug(sym.toString());
            if (sym.isParam() || !sym.owner().equals(cSym) || filtered.contains(sym.full())) continue;
            if (sym.isAccessor()) {
                if (sym.name().trim().endsWith("$eq")) continue;
                fields.add(new FieldMixin(sym.name().trim(), Type.getReturnType((String)sym.jDesc()).getDescriptor(), sym.isPrivate() ? 2 : 1));
                continue;
            }
            if (!sym.isMethod()) continue;
            String desc = sym.jDesc();
            if (sym.name().startsWith("super$")) {
                supers.add(sym.name().substring(6) + desc);
                continue;
            }
            if (sym.isPrivate() || sym.isDeferred() || sym.name().equals("$init$")) continue;
            String objectDesc = Type.getMethodDescriptor((Type)Type.getObjectType((String)(Type.getReturnType((String)desc).getInternalName() + "$")), (Type[])Type.getArgumentTypes((String)desc));
            MethodNode mNode = (MethodNode)FastStream.of((Iterable)cNode.methods).filter(e -> e.name.equals(sym.name()) && (e.desc.equals(desc) || e.desc.equals(objectDesc))).firstOrDefault();
            if (mNode == null) {
                throw new IllegalArgumentException("Unable to add mixin trait " + cNode.name + ": " + sym.name() + desc + " found in scala signature but not in class file. Most likely an obfuscation issue.");
            }
            methods.add(mNode);
        }
        return new MixinInfo(cNode.name, cSym.jParent(), parentTraits, fields, methods, supers);
    }

    private List<MixinInfo> getAndRegisterParentTraits(ClassNode cNode) {
        return FastStream.of((Iterable)cNode.interfaces).map(this.mixinCompiler::getClassInfo).filter(e -> {
            ScalaClassInfo info;
            return e instanceof ScalaClassInfo && (info = (ScalaClassInfo)e).isTrait() && !info.cSym.isInterface();
        }).map(e -> this.mixinCompiler.registerTrait(((ScalaClassInfo)e).getCNode())).toList();
    }

    private Set<String> listFiltered(ScalaSignature sig) {
        return FastStream.of(sig.collect(40)).filter(e -> {
            ScalaSignature.Literal value = (ScalaSignature.Literal)e.getValue("value");
            if (!(value instanceof ScalaSignature.EnumLiteral)) return false;
            ScalaSignature.EnumLiteral lit = (ScalaSignature.EnumLiteral)value;
            if (!this.mixinCompiler.getMixinBackend().filterMethodAnnotations(e.annType().name(), lit.value().full())) return false;
            return true;
        }).map(e -> e.owner().full()).toSet();
    }
}

