/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.MethodInfo;
import java.util.List;
import net.covers1624.quack.collection.FastStream;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassNodeInfo
extends ClassInfo {
    private final ClassNode cNode;
    protected List<ClassInfo> interfaces;
    private final List<MethodInfo> methods;

    public ClassNodeInfo(MixinCompiler mixinCompiler, ClassNode cNode) {
        super(mixinCompiler);
        this.cNode = cNode;
        this.interfaces = FastStream.of((Iterable)cNode.interfaces).map(mixinCompiler::getClassInfo).toList();
        this.methods = FastStream.of((Iterable)cNode.methods).map(x$0 -> new MethodNodeInfo((MethodNode)x$0)).toList(FastStream.infer());
    }

    @Override
    public String getName() {
        return this.cNode.name;
    }

    @Override
    public boolean isInterface() {
        return (this.cNode.access & 0x200) != 0;
    }

    @Override
    public ClassInfo getSuperClass() {
        return this.cNode.superName != null ? this.mixinCompiler.getClassInfo(this.cNode.superName) : null;
    }

    @Override
    public Iterable<ClassInfo> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public Iterable<MethodInfo> getMethods() {
        return this.methods;
    }

    public ClassNode getCNode() {
        return this.cNode;
    }

    public class MethodNodeInfo
    implements MethodInfo {
        private final MethodNode mNode;
        private final String[] exceptions;

        public MethodNodeInfo(MethodNode mNode) {
            this.mNode = mNode;
            this.exceptions = mNode.exceptions.toArray(new String[0]);
        }

        @Override
        public ClassInfo getOwner() {
            return ClassNodeInfo.this;
        }

        @Override
        public String getName() {
            return this.mNode.name;
        }

        @Override
        public String getDesc() {
            return this.mNode.desc;
        }

        @Override
        public String[] getExceptions() {
            return this.exceptions;
        }

        @Override
        public boolean isPrivate() {
            return (this.mNode.access & 2) != 0;
        }

        @Override
        public boolean isAbstract() {
            return (this.mNode.access & 0x400) != 0;
        }
    }
}

