/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.raytracer.SubHitBlockHitResult;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartRayTraceResult;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultipartVoxelShape
extends VoxelShape {
    private final VoxelShape shape;
    private final TileMultipart tile;

    public MultipartVoxelShape(VoxelShape shape, TileMultipart tile) {
        super(shape.f_83211_);
        this.shape = shape;
        this.tile = tile;
    }

    public DoubleList m_7700_(Direction.Axis axis) {
        return this.shape.m_7700_(axis);
    }

    public BlockHitResult m_83220_(Vec3 start, Vec3 end, BlockPos pos) {
        PartRayTraceResult closest = null;
        for (MultiPart part : this.tile.getPartList()) {
            PartRayTraceResult result;
            BlockHitResult hit = part.getInteractionShape().m_83220_(start, end, pos);
            if (hit == null) {
                hit = part.getShape(CollisionContext.m_82749_()).m_83220_(start, end, pos);
            }
            if (hit == null) continue;
            if (hit instanceof SubHitBlockHitResult) {
                SubHitBlockHitResult sHit = (SubHitBlockHitResult)hit;
                result = new PartRayTraceResult(part, sHit);
            } else {
                result = new PartRayTraceResult(part, hit, start);
            }
            if (closest != null && result.compareTo(closest) >= 0) continue;
            closest = result;
        }
        return closest;
    }
}

