/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.capability;

import com.buuz135.industrial.gui.component.ItemStackTankScreenAddon;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.capability.FluidHandlerScreenProviderItemStack;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MultipleFluidHandlerScreenProviderItemStack
extends FluidHandlerScreenProviderItemStack {
    private static String NBT_TANKS = "Tanks";
    private TankDefinition[] tankDefinitions;

    public MultipleFluidHandlerScreenProviderItemStack(@Nonnull ItemStack container, int capacity, TankDefinition ... tankDefinitions) {
        super(container, capacity);
        this.tankDefinitions = tankDefinitions;
    }

    public boolean isFluidValid(FluidStack stack) {
        return Arrays.stream(this.tankDefinitions).anyMatch(tankDefinition -> tankDefinition.validator.test(stack));
    }

    @Nonnull
    public FluidStack getFluid() {
        for (int i = 0; i < this.tankDefinitions.length; ++i) {
            if (!this.tankDefinitions[i].canDrain) continue;
            return this.getFluidInTank(i);
        }
        return super.getFluid();
    }

    public int getFluidAmount() {
        for (int i = 0; i < this.tankDefinitions.length; ++i) {
            if (!this.tankDefinitions[i].canDrain) continue;
            return this.getFluidInTank(i).getAmount();
        }
        return super.getFluidAmount();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        CompoundTag compoundNBT = this.getContainer().m_41698_(NBT_TANKS);
        if (!compoundNBT.m_128441_(this.tankDefinitions[tank].name)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)compoundNBT.m_128469_(this.tankDefinitions[tank].name));
    }

    public void setFluidInTank(int tank, FluidStack fluidStack) {
        CompoundTag compoundNBT = this.getContainer().m_41698_(NBT_TANKS);
        compoundNBT.m_128365_(this.tankDefinitions[tank].name, (Tag)fluidStack.writeToNBT(new CompoundTag()));
    }

    public int getTanks() {
        return this.tankDefinitions.length;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (this.container.m_41613_() != 1 || resource.isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        for (int i = 0; i < this.tankDefinitions.length; ++i) {
            if (!this.tankDefinitions[i].canFill || !this.tankDefinitions[i].validator.test(resource)) continue;
            FluidStack contained = this.getFluidInTank(i);
            if (contained.isEmpty()) {
                int fillAmount = Math.min(this.capacity, resource.getAmount());
                if (doFill.execute()) {
                    FluidStack filled = resource.copy();
                    filled.setAmount(fillAmount);
                    this.setFluidInTank(i, filled);
                }
                return fillAmount;
            }
            if (contained.isFluidEqual(resource)) {
                int fillAmount = Math.min(this.capacity - contained.getAmount(), resource.getAmount());
                if (doFill.execute() && fillAmount > 0) {
                    contained.grow(fillAmount);
                    this.setFluidInTank(i, contained);
                }
                return fillAmount;
            }
            return 0;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || resource.isEmpty() || !resource.isFluidEqual(this.getFluid())) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        for (int i = 0; i < this.tankDefinitions.length; ++i) {
            if (!this.tankDefinitions[i].canDrain) continue;
            FluidStack contained = this.getFluidInTank(i);
            if (contained.isEmpty()) {
                return FluidStack.EMPTY;
            }
            int drainAmount = Math.min(contained.getAmount(), maxDrain);
            FluidStack drained = contained.copy();
            drained.setAmount(drainAmount);
            if (action.execute()) {
                contained.shrink(drainAmount);
                if (contained.isEmpty()) {
                    this.setFluidInTank(i, FluidStack.EMPTY);
                } else {
                    this.setFluidInTank(i, contained);
                }
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>();
        int i = 0;
        while (i < this.tankDefinitions.length) {
            int finalI = i++;
            addons.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ItemStackTankScreenAddon(this.tankDefinitions[finalI].x, this.tankDefinitions[finalI].y, (IFluidHandler)this, finalI, this.tankDefinitions[finalI].type)));
        }
        return addons;
    }

    public static class TankDefinition {
        private final String name;
        private final int x;
        private final int y;
        private final Predicate<FluidStack> validator;
        private final boolean canDrain;
        private final boolean canFill;
        private final FluidTankComponent.Type type;

        public TankDefinition(String name, int x, int y, Predicate<FluidStack> validator, boolean canDrain, boolean canFill, FluidTankComponent.Type type) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.validator = validator;
            this.canDrain = canDrain;
            this.canFill = canFill;
            this.type = type;
        }
    }
}

