/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.transporter;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.network.TransporterButtonInteractMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GuiTransporter
extends AbstractContainerScreen<ContainerTransporter>
implements ICanSendNetworkMessage {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("industrialforegoing", "textures/gui/conveyor.png");
    private TransporterType upgrade = this.getMenu().getConveyor().getTransporterTypeMap().get(this.getMenu().getFacing());
    private List<IGuiComponent> componentList = new ArrayList<IGuiComponent>();
    private int x;
    private int y;
    private List<IFilter.GhostSlot> ghostSlots = new ArrayList<IFilter.GhostSlot>();

    public GuiTransporter(ContainerTransporter inventorySlotsIn, Inventory inventory, Component component) {
        super((AbstractContainerMenu)inventorySlotsIn, inventory, component);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.componentList.clear();
        this.upgrade.addComponentsToGui(this.componentList);
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!(iGuiComponent instanceof FilterGuiComponent)) continue;
            this.ghostSlots.addAll(Arrays.asList(((FilterGuiComponent)iGuiComponent).getFilter().getFilter()));
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(BG_TEXTURE, this.x, this.y, 0, 0, this.f_97726_, this.f_97727_);
        if (this.upgrade != null) {
            String localized = Component.m_237115_((String)this.upgrade.getFactory().getUpgradeItem().m_5524_()).getString();
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, localized, this.x + this.f_97726_ / 2 - this.getMinecraft().f_91062_.m_92895_(localized) / 2, this.y + 6, 0x404040, false);
        }
        for (IGuiComponent iGuiComponent : this.componentList) {
            iGuiComponent.drawGuiBackgroundLayer(guiGraphics, this.x, this.y, mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        for (IGuiComponent iGuiComponent : this.componentList) {
            iGuiComponent.drawGuiForegroundLayer(guiGraphics, this.x, this.y, mouseX, mouseY);
        }
        this.m_280072_(guiGraphics, mouseX - this.x, mouseY - this.y);
        for (IGuiComponent iGuiComponent : this.componentList) {
            List<Component> tooltips;
            if (!iGuiComponent.isInside(mouseX - this.x, mouseY - this.y) || (tooltips = iGuiComponent.getTooltip(this.x, this.y, mouseX, mouseY)) == null) continue;
            guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, tooltips, mouseX - this.x, mouseY - this.y);
        }
    }

    public ContainerTransporter getMenu() {
        return (ContainerTransporter)super.m_6262_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean click = super.m_6375_(mouseX, mouseY, mouseButton);
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!iGuiComponent.isInside(mouseX - (double)this.x, mouseY - (double)this.y) || !iGuiComponent.handleClick(this, this.x, this.y, mouseX, mouseY)) continue;
            return true;
        }
        return click;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean click = super.m_6050_(mouseX, mouseY, delta);
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!iGuiComponent.isInside(mouseX - (double)this.x, mouseY - (double)this.y) || !iGuiComponent.onScrolled(this, this.x, this.y, mouseX, mouseY, delta)) continue;
            return true;
        }
        return click;
    }

    @Override
    public void sendMessage(int id, CompoundTag compound) {
        IndustrialForegoing.NETWORK.get().sendToServer((Object)new TransporterButtonInteractMessage(this.upgrade.getPos(), id, this.upgrade.getSide(), compound));
    }

    public List<IFilter.GhostSlot> getGhostSlots() {
        return this.ghostSlots;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

