/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.satisfy.brewery.core.effect.alcohol.AlcoholLevel;
import net.satisfy.brewery.core.effect.alcohol.AlcoholPlayer;
import net.satisfy.brewery.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Breathalyzer
extends Item {
    public Breathalyzer(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        itemStack.m_41751_(new CompoundTag());
        player.m_6672_(interactionHand);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEventRegistry.BREATH.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    private void addNbt(LivingEntity livingEntity) {
        if (livingEntity instanceof AlcoholPlayer) {
            AlcoholPlayer alcoholPlayer = (AlcoholPlayer)livingEntity;
            ItemStack itemStack = livingEntity.m_21120_(livingEntity.m_7655_());
            CompoundTag nbtData = new CompoundTag();
            AlcoholLevel alcoholLevel = alcoholPlayer.brewery$getAlcohol();
            nbtData.m_128359_("brewery.drunkenness", alcoholLevel.isBlackout() ? "DANGER" : (alcoholLevel.isDrunk() ? "WARNING" : "EASY"));
            itemStack.m_41751_(nbtData);
        }
    }

    @NotNull
    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.TOOT_HORN;
    }

    public int m_8105_(ItemStack itemStack) {
        return 100;
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int tick) {
        if (this.m_8105_(itemStack) - tick == 60) {
            this.addNbt(livingEntity);
        }
        super.m_5929_(level, livingEntity, itemStack, tick);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (itemStack.m_41782_()) {
            String drunkenness;
            assert (itemStack.m_41783_() != null);
            MutableComponent tooltip = switch (drunkenness = itemStack.m_41783_().m_128461_("brewery.drunkenness")) {
                case "DANGER" -> Component.m_237115_((String)drunkenness).m_130940_(ChatFormatting.RED);
                case "WARNING" -> Component.m_237115_((String)drunkenness).m_130940_(ChatFormatting.GOLD);
                case "EASY" -> Component.m_237115_((String)drunkenness).m_130940_(ChatFormatting.GREEN);
                default -> Component.m_237115_((String)drunkenness);
            };
            list.add((Component)tooltip);
        }
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }
}

