/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.brewery.core.block.entity.StorageBlockEntity;
import net.satisfy.brewery.core.effect.alcohol.AlcoholManager;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrinkBlockItem
extends BlockItem {
    private final MobEffect effect;
    private final int baseDuration;

    public DrinkBlockItem(MobEffect effect, int duration, Block block, Item.Properties settings) {
        super(block, settings);
        this.effect = effect;
        this.baseDuration = duration;
    }

    public static void addQuality(ItemStack itemStack, int quality) {
        itemStack.m_41784_().m_128405_("brewery.beer_quality", Math.min(Math.max(quality, 1), 3));
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    protected BlockState m_5965_(BlockPlaceContext context) {
        if (!Objects.requireNonNull(context.m_43723_()).m_6047_()) {
            return null;
        }
        BlockState blockState = this.m_40614_().m_5573_(context);
        return blockState != null && this.m_40610_(context, blockState) ? blockState : null;
    }

    protected boolean m_7274_(BlockPos blockPos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity beerEntity = (StorageBlockEntity)blockEntity;
            beerEntity.setStack(0, itemStack.m_255036_(1));
        }
        return super.m_7274_(blockPos, level, player, itemStack, blockState);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)interactionHand);
    }

    @NotNull
    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        Player player;
        ItemStack returnStack = super.m_5922_(itemStack, level, livingEntity);
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_7500_()) {
            player.m_36356_(new ItemStack((ItemLike)ObjectRegistry.BEER_MUG.get()));
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            AlcoholManager.drinkAlcohol(serverPlayer);
            if (itemStack.m_41782_() && Objects.requireNonNull(itemStack.m_41783_()).m_128441_("brewery.beer_quality")) {
                int quality = itemStack.m_41783_().m_128451_("brewery.beer_quality");
                MobEffectInstance effectInstance = this.calculateEffectForQuality(quality);
                serverPlayer.m_7292_(effectInstance);
            } else {
                MobEffectInstance effectInstance = new MobEffectInstance(this.effect, this.baseDuration, 0);
                serverPlayer.m_7292_(effectInstance);
            }
        }
        return returnStack;
    }

    @NotNull
    private MobEffectInstance calculateEffectForQuality(int quality) {
        int durationMultiplier = 1;
        int effectLevel = switch (quality) {
            case 2 -> {
                durationMultiplier = 3;
                yield 2;
            }
            case 3 -> {
                durationMultiplier = 5;
                yield 3;
            }
            default -> 1;
        };
        return new MobEffectInstance(this.effect, this.baseDuration * durationMultiplier, effectLevel - 1);
    }

    public void addCount(ItemStack resultSack, int solved) {
        resultSack.m_41764_(solved);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        int effectLevel;
        int beerQuality = stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_("brewery.beer_quality") ? stack.m_41783_().m_128451_("brewery.beer_quality") : 1;
        int durationMultiplier = 1;
        switch (beerQuality) {
            case 2: {
                durationMultiplier = 3;
                int n = 2;
                break;
            }
            case 3: {
                durationMultiplier = 5;
                int n = 3;
                break;
            }
            default: {
                int n = effectLevel = 1;
            }
        }
        if (this.effect != null) {
            MutableComponent effectName = Component.m_237115_((String)this.effect.m_19481_());
            if (effectLevel > 1) {
                effectName.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("potion.potency." + (effectLevel - 1))));
            }
            String durationText = MobEffectUtil.m_267641_((MobEffectInstance)new MobEffectInstance(this.effect, this.baseDuration * durationMultiplier), (float)1.0f).getString();
            MutableComponent effectDuration = Component.m_237115_((String)" (").m_7220_((Component)Component.m_237115_((String)durationText)).m_7220_((Component)Component.m_237115_((String)")"));
            tooltip.add((Component)effectName.m_7220_((Component)effectDuration).m_130940_(this.effect.m_19483_().m_19497_()));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        }
        if (beerQuality > 1) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.brewery.beer_quality", (Object[])new Object[]{beerQuality}).m_130940_(ChatFormatting.GOLD));
        }
    }
}

