/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.brewery.core.block.entity.BeerMugBlockEntity;
import net.satisfy.brewery.core.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.core.block.entity.CabinetBlockEntity;
import net.satisfy.brewery.core.block.entity.CompletionistBannerEntity;
import net.satisfy.brewery.core.block.entity.StorageBlockEntity;
import net.satisfy.brewery.core.block.entity.rope.HangingRopeEntity;
import net.satisfy.brewery.core.block.entity.rope.RopeCollisionEntity;
import net.satisfy.brewery.core.block.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.core.entity.BeerElementalAttackEntity;
import net.satisfy.brewery.core.entity.BeerElementalEntity;
import net.satisfy.brewery.core.entity.DarkBrewEntity;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.registry.StorageTypeRegistry;
import net.satisfy.brewery.core.util.BreweryIdentifier;

public class EntityTypeRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256922_);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<EntityType<DarkBrewEntity>> DARK_BREW = EntityTypeRegistry.registerEntityType("dark_brew", () -> EntityType.Builder.m_20704_(DarkBrewEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20712_(new BreweryIdentifier("dark_brew").toString()));
    public static final RegistrySupplier<EntityType<RopeKnotEntity>> ROPE_KNOT = EntityTypeRegistry.registerEntityType("rope_knot", () -> EntityType.Builder.m_20704_(RopeKnotEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.375f, 0.25f).m_20702_(20).m_20720_().m_20719_().m_20712_(new BreweryIdentifier("rope_knot").toString()));
    public static final RegistrySupplier<EntityType<RopeCollisionEntity>> ROPE_COLLISION = EntityTypeRegistry.registerEntityType("rope_collision", () -> EntityType.Builder.m_20704_(RopeCollisionEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(10).m_20716_().m_20698_().m_20719_().m_20712_(new BreweryIdentifier("rope_collision").toString()));
    public static final RegistrySupplier<EntityType<HangingRopeEntity>> HANGING_ROPE = EntityTypeRegistry.registerEntityType("hanging_rope", () -> EntityType.Builder.m_20704_(HangingRopeEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(10).m_20716_().m_20698_().m_20719_().m_20712_(new BreweryIdentifier("hanging_rope").toString()));
    public static final RegistrySupplier<EntityType<BeerElementalEntity>> BEER_ELEMENTAL = EntityTypeRegistry.registerEntityType("beer_elemental", () -> EntityType.Builder.m_20704_(BeerElementalEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 1.6f).m_20702_(80).m_20717_(3).m_20712_(new BreweryIdentifier("beer_elemental").toString()));
    public static final RegistrySupplier<EntityType<BeerElementalAttackEntity>> BEER_ELEMENTAL_ATTACK = EntityTypeRegistry.registerEntityType("beer_elemental_attack", () -> EntityType.Builder.m_20704_(BeerElementalAttackEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).m_20702_(4).m_20717_(10).m_20712_(new BreweryIdentifier("beer_elemental_attack").toString()));
    public static final RegistrySupplier<BlockEntityType<BrewstationBlockEntity>> BREWINGSTATION_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("brewingstation", () -> BlockEntityType.Builder.m_155273_(BrewstationBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.WOODEN_BREWINGSTATION.get(), (Block)ObjectRegistry.COPPER_BREWINGSTATION.get(), (Block)ObjectRegistry.NETHERITE_BREWINGSTATION.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<BeerMugBlockEntity>> BEER_MUG_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("beer_mug", () -> BlockEntityType.Builder.m_155273_(BeerMugBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BEER_MUG.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.m_155273_(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.m_155273_(CabinetBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> BREWERY_BANNER = EntityTypeRegistry.registerBlockEntity("brewery_banner", () -> BlockEntityType.Builder.m_155273_(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BREWERY_BANNER.get(), (Block)ObjectRegistry.BREWERY_WALL_BANNER.get()}).m_58966_(null));

    public static void registerBeerElemental(Supplier<? extends EntityType<? extends Monster>> typeSupplier) {
        EntityAttributeRegistry.register(typeSupplier, BeerElementalEntity::createAttributes);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new BreweryIdentifier(path), type);
    }

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntityType(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new BreweryIdentifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
        EntityTypeRegistry.registerBeerElemental(BEER_ELEMENTAL);
    }
}

