/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.events.ServerBuildList;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Config;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.Styles;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GadgetExchanger
extends BaseGadget {
    @Override
    public int getEnergyMax() {
        return (Integer)Config.EXCHANGINGGADGET_MAXPOWER.get();
    }

    @Override
    public int getEnergyCost() {
        return (Integer)Config.EXCHANGINGGADGET_COST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (level == null || mc.f_91074_ == null) {
            return;
        }
        boolean sneakPressed = Screen.m_96638_();
        if (sneakPressed) {
            BaseMode mode = GadgetNBT.getMode(stack);
            tooltip.add((Component)Component.m_237110_((String)"buildinggadgets2.tooltips.mode", (Object[])new Object[]{Component.m_237115_((String)mode.i18n())}).m_6270_(Styles.AQUA));
            tooltip.add((Component)Component.m_237110_((String)"buildinggadgets2.tooltips.range", (Object[])new Object[]{GadgetNBT.getToolRange(stack)}).m_6270_(Styles.LT_PURPLE));
            tooltip.add((Component)Component.m_237110_((String)"buildinggadgets2.tooltips.blockstate", (Object[])new Object[]{GadgetNBT.getGadgetBlockState(stack).m_60734_().m_49954_()}).m_6270_(Styles.DK_GREEN));
        }
    }

    @Override
    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BlockState setState = GadgetNBT.getGadgetBlockState(gadget);
        if (setState.m_60795_()) {
            return InteractionResultHolder.m_19098_((Object)gadget);
        }
        BaseMode mode = GadgetNBT.getMode(gadget);
        ArrayList<StatePos> buildList = mode.collect(context.hitResult().m_82434_(), context.player(), GadgetExchanger.getHitPos(context), setState);
        UUID buildUUID = BuildingUtils.exchange(context.level(), context.player(), buildList, GadgetExchanger.getHitPos(context), gadget, true, true);
        GadgetUtils.addToUndoList(context.level(), gadget, new ArrayList<StatePos>(), buildUUID);
        GadgetNBT.clearAnchorPos(gadget);
        return InteractionResultHolder.m_19090_((Object)gadget);
    }

    @Override
    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        BlockState blockState = context.level().m_8055_(context.pos());
        if (!GadgetUtils.isValidBlockState(blockState, context.level(), context.pos()) || blockState.m_60734_() instanceof RenderBlock) {
            context.player().m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.invalidblock"), true);
            return super.onShiftAction(context);
        }
        if (GadgetUtils.setBlockState(context.stack(), blockState)) {
            return InteractionResultHolder.m_19090_((Object)context.stack());
        }
        return super.onShiftAction(context);
    }

    @Override
    public void undo(Level level, Player player, ItemStack gadget) {
        if (!this.canUndo(level, player, gadget)) {
            return;
        }
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.m_7654_()).m_129783_());
        UUID buildUUID = GadgetNBT.popUndoList(gadget);
        ServerTickHandler.stopBuilding(buildUUID);
        ArrayList<StatePos> undoList = bg2Data.popUndoList(buildUUID);
        if (undoList.isEmpty()) {
            return;
        }
        Collections.reverse(undoList);
        UUID newBuildUUID = UUID.randomUUID();
        for (StatePos pos : undoList) {
            if (pos.state.m_60795_() || !pos.state.m_60710_((LevelReader)level, pos.pos)) continue;
            if (!player.m_7500_() && !BuildingUtils.hasEnoughEnergy(gadget)) {
                player.m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.outofpower"), true);
                break;
            }
            if (!player.m_7500_()) {
                BuildingUtils.useEnergy(gadget);
            }
            ServerTickHandler.addToMap(newBuildUUID, new StatePos(pos.state, pos.pos), level, GadgetNBT.getRenderTypeByte(gadget), player, true, true, gadget, ServerBuildList.BuildType.EXCHANGE, true, GadgetNBT.nullPos);
        }
    }

    @Override
    public GadgetTarget gadgetTarget() {
        return GadgetTarget.EXCHANGING;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 3;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.m_44831_((ItemStack)book).containsKey(Enchantments.f_44985_) || super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44985_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

