/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class AvoidEntity<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT)});
    protected Predicate<LivingEntity> avoidingPredicate = target -> false;
    protected float noCloserThanSqr = 9.0f;
    protected float stopAvoidingAfterSqr = 49.0f;
    protected float speedModifier = 1.0f;
    private Path runPath = null;

    public AvoidEntity() {
        this.noTimeout();
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public AvoidEntity<E> noCloserThan(float blocks) {
        this.noCloserThanSqr = blocks * blocks;
        return this;
    }

    public AvoidEntity<E> stopCaringAfter(float blocks) {
        this.stopAvoidingAfterSqr = blocks * blocks;
        return this;
    }

    public AvoidEntity<E> avoiding(Predicate<LivingEntity> predicate) {
        this.avoidingPredicate = predicate;
        return this;
    }

    public AvoidEntity<E> speedModifier(float mod) {
        this.speedModifier = mod;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Optional target = ((NearestVisibleLivingEntities)BrainUtils.getMemory(entity, MemoryModuleType.f_148205_)).m_186116_(this.avoidingPredicate);
        if (target.isEmpty()) {
            return false;
        }
        LivingEntity avoidingEntity = (LivingEntity)target.get();
        double distToTarget = avoidingEntity.m_20280_(entity);
        if (distToTarget > (double)this.noCloserThanSqr) {
            return false;
        }
        Vec3 runPos = DefaultRandomPos.m_148407_(entity, (int)16, (int)7, (Vec3)avoidingEntity.m_20182_());
        if (runPos == null || avoidingEntity.m_20275_(runPos.f_82479_, runPos.f_82480_, runPos.f_82481_) < distToTarget) {
            return false;
        }
        this.runPath = entity.m_21573_().m_26524_(runPos.f_82479_, runPos.f_82480_, runPos.f_82481_, 0);
        return this.runPath != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return !this.runPath.m_77392_();
    }

    @Override
    protected void start(E entity) {
        entity.m_21573_().m_26536_(this.runPath, (double)this.speedModifier);
    }

    @Override
    protected void stop(E entity) {
        this.runPath = null;
        entity.m_21573_().m_26517_(1.0);
    }
}

