/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.client.MicroblockRender;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import mrtjp.projectred.transmission.client.FramedJacketedWireModel;
import mrtjp.projectred.transmission.client.FramedJacketedWireModelBuilder;
import mrtjp.projectred.transmission.client.FramedWireModelBuilder;
import mrtjp.projectred.transmission.client.FramedWireScaffoldingModelBuilder;
import mrtjp.projectred.transmission.part.BaseCenterWirePart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class FramedWireModelRenderer {
    private static final CCModel[] scaffoldModels = new FramedWireScaffoldingModelBuilder().build();
    private static final CCModel[] wireModels = new CCModel[192];
    private static final FramedJacketedWireModel[] jacketModels = new FramedJacketedWireModel[192];

    private static int modelKey(int thickness, int connMap) {
        return thickness << 6 | connMap;
    }

    private static int modelKey(BaseCenterWirePart wire) {
        return FramedWireModelRenderer.modelKey(wire.getWireType().getThickness(), wire.getConnMap());
    }

    public static CCModel getOrGenerateWireModel(int key) {
        CCModel model = wireModels[key];
        if (model == null) {
            FramedWireModelRenderer.wireModels[key] = model = new FramedWireModelBuilder().setModelKey(key).build();
        }
        return model;
    }

    public static FramedJacketedWireModel getOrGenerateJacketModel(int key) {
        FramedJacketedWireModel model = jacketModels[key];
        if (model == null) {
            FramedWireModelRenderer.jacketModels[key] = model = new FramedJacketedWireModelBuilder().setModelKey(key).build();
        }
        return model;
    }

    public static void render(CCRenderState ccrs, BaseCenterWirePart wire) {
        FramedWireModelRenderer.render(ccrs, FramedWireModelRenderer.modelKey(wire), wire.getRenderHue(), wire.getIcon(), wire.getMaterial());
    }

    public static void render(CCRenderState ccrs, int modelKey, int hue, TextureAtlasSprite icon, @Nullable MicroMaterial material) {
        IconTransformation uvt = new IconTransformation(icon);
        ColourMultiplier c = ColourMultiplier.instance((int)hue);
        if (material != null) {
            FramedJacketedWireModel model = FramedWireModelRenderer.getOrGenerateJacketModel(modelKey);
            model.renderWire(ccrs, new IVertexOperation[]{uvt, c});
            model.renderMaterial(ccrs, material, false);
        } else {
            FramedWireModelRenderer.getOrGenerateWireModel(modelKey).render(ccrs, new IVertexOperation[]{uvt, c});
            FramedWireModelRenderer.renderWireScaffold(modelKey, ccrs, new IVertexOperation[]{uvt});
        }
    }

    public static void renderWireScaffold(int key, CCRenderState ccrs, IVertexOperation ... ops) {
        scaffoldModels[6].render(ccrs, ops);
        for (int s = 0; s < 6; ++s) {
            if ((key & 1 << s) == 0) continue;
            scaffoldModels[s].render(ccrs, ops);
        }
    }

    public static void renderInventory(CCRenderState ccrs, int thickness, int hue, TextureAtlasSprite icon, Transformation transformation) {
        IconTransformation uvt = new IconTransformation(icon);
        ColourMultiplier c = ColourMultiplier.instance((int)hue);
        FramedWireModelRenderer.getOrGenerateWireModel(FramedWireModelRenderer.modelKey(thickness, 60)).render(ccrs, new IVertexOperation[]{uvt, c, transformation});
        FramedWireModelRenderer.renderWireScaffold(FramedWireModelRenderer.modelKey(thickness, 0), ccrs, new IVertexOperation[]{uvt, transformation});
    }

    public static void renderCoverHighlight(BaseCenterWirePart wire, MicroMaterial material, CCRenderState ccrs, PoseStack mStack, MultiBufferSource getter) {
        BlockPos pos = wire.pos();
        Matrix4 mat = new Matrix4(mStack);
        mat.translate((Vec3i)pos);
        mat.apply(new Scale(1.002, 1.002, 1.002).at(Vector3.CENTER));
        ccrs.reset();
        ccrs.bind(MicroblockRender.HIGHLIGHT_RENDER_TYPE, getter, mat);
        ccrs.alphaOverride = 127;
        FramedWireModelRenderer.getOrGenerateJacketModel(FramedWireModelRenderer.modelKey(wire)).renderHighlight(ccrs, material, true);
    }
}

