/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UVTransformation;
import mrtjp.projectred.core.UVT;
import mrtjp.projectred.transmission.client.WireModelBuilder;

public class FramedWireScaffoldingModelBuilder {
    private final CCModel[] models = new CCModel[7];
    private final double w = 0.25;
    private final double d = 0.0605;
    private boolean modelBuilt = false;

    public CCModel[] build() {
        if (!this.modelBuilt) {
            this.buildModel();
            this.modelBuilt = true;
            return this.models;
        }
        CCModel[] modelsCopy = new CCModel[this.models.length];
        for (int i = 0; i < this.models.length; ++i) {
            modelsCopy[i] = this.models[i].copy();
        }
        return modelsCopy;
    }

    private void buildModel() {
        this.generateCenterModel();
        this.generateSideModels();
        this.finihModels();
    }

    private void generateCenterModel() {
        CCModel model = CCModel.quadModel((int)48);
        model.verts[0] = new Vertex5(0.25, 0.25, 0.25, 20.0, 8.0);
        model.verts[1] = new Vertex5(0.75, 0.25, 0.25, 28.0, 8.0);
        model.verts[2] = new Vertex5(0.75, 0.25, 0.75, 28.0, 0.0);
        model.verts[3] = new Vertex5(0.25, 0.25, 0.75, 20.0, 0.0);
        model.verts[4] = new Vertex5(0.25, 0.3105, 0.75, 20.0, 8.0);
        model.verts[5] = new Vertex5(0.75, 0.3105, 0.75, 28.0, 8.0);
        model.verts[6] = new Vertex5(0.75, 0.3105, 0.25, 28.0, 0.0);
        model.verts[7] = new Vertex5(0.25, 0.3105, 0.25, 20.0, 0.0);
        model.generateSidedParts(0, Vector3.CENTER);
        this.models[6] = model;
    }

    private void generateSideModels() {
        CCModel model = CCModel.quadModel((int)36);
        model.verts[0] = new Vertex5(0.25, 0.0, 0.75, 16.0, 0.0);
        model.verts[1] = new Vertex5(0.75, 0.0, 0.75, 16.0, 8.0);
        model.verts[2] = new Vertex5(0.75, 0.25, 0.75, 20.0, 8.0);
        model.verts[3] = new Vertex5(0.25, 0.25, 0.75, 20.0, 0.0);
        model.verts[4] = new Vertex5(0.75, 0.0, 0.6895, 16.0, 0.0);
        model.verts[5] = new Vertex5(0.25, 0.0, 0.6895, 16.0, 8.0);
        model.verts[6] = new Vertex5(0.25, 0.25, 0.6895, 20.0, 8.0);
        model.verts[7] = new Vertex5(0.75, 0.25, 0.6895, 20.0, 0.0);
        for (int r = 1; r < 4; ++r) {
            model.apply(Rotation.quarterRotations[r].at(Vector3.CENTER), 0, r * 8, 8);
        }
        model.verts[32] = new Vertex5(0.25, 0.0, 0.25, 24.0, 32.0);
        model.verts[33] = new Vertex5(0.75, 0.0, 0.25, 32.0, 32.0);
        model.verts[34] = new Vertex5(0.75, 0.0, 0.75, 32.0, 24.0);
        model.verts[35] = new Vertex5(0.25, 0.0, 0.75, 24.0, 24.0);
        this.models[0] = model;
        UVT t = new UVT(Rotation.quarterRotations[2].at(new Vector3(24.0, 0.0, 4.0)));
        for (int s = 1; s < 6; ++s) {
            this.models[s] = model.copy().apply(Rotation.sideRotations[s].at(Vector3.CENTER));
            if (s % 2 != 1) continue;
            Vertex5[] verts = this.models[s].verts;
            for (int i = 0; i < 32; ++i) {
                verts[i].apply((UVTransformation)t);
            }
        }
    }

    private void finihModels() {
        for (CCModel model : this.models) {
            WireModelBuilder.finishModel(model);
        }
    }
}

