/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.core.power.IPowerConductorSource;
import mrtjp.projectred.core.power.IPowerConnectable;
import mrtjp.projectred.core.power.PowerConductor;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.part.BaseCenterWirePart;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public abstract class FramedPowerWire
extends BaseCenterWirePart
implements IPowerConnectable,
IPowerConductorSource {
    private final List<PowerConductor> connectedConductors = new LinkedList<PowerConductor>();
    private boolean cacheInvalid = true;

    public FramedPowerWire(WireType wireType) {
        super(wireType);
    }

    public long getTime() {
        return this.level().m_46467_();
    }

    public List<PowerConductor> getConnectedConductors() {
        if (this.cacheInvalid) {
            this.recacheConductors();
            this.cacheInvalid = false;
        }
        return this.connectedConductors;
    }

    private void recacheConductors() {
        this.connectedConductors.clear();
        for (int s = 0; s < 6; ++s) {
            CenterLookup lookup;
            if (this.maskConnectsIn(s)) {
                lookup = CenterLookup.lookupInsideFace((Level)this.level(), (BlockPos)this.pos(), (int)s);
            } else {
                if (!this.maskConnectsOut(s)) continue;
                lookup = CenterLookup.lookupStraightCenter((Level)this.level(), (BlockPos)this.pos(), (int)s);
            }
            PowerConductor c = this.retrieveConductor(lookup);
            if (c == null) continue;
            this.connectedConductors.add(c);
        }
    }

    @Nullable
    private PowerConductor retrieveConductor(CenterLookup lookup) {
        if (lookup.part instanceof IPowerConnectable) {
            return ((IPowerConnectable)lookup.part).getConductor(lookup.otherDirection);
        }
        if (lookup.tile instanceof IPowerConnectable) {
            return ((IPowerConnectable)lookup.tile).getConductor(lookup.otherDirection);
        }
        return null;
    }

    @Override
    public void maskChangeEvent(boolean internalChange, boolean externalChange) {
        super.maskChangeEvent(internalChange, externalChange);
        this.cacheInvalid = true;
    }

    public boolean discoverStraightOverride(int absDir) {
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.level(), (BlockPos)this.pos(), (int)absDir);
        if (lookup.tile instanceof IConnectable) {
            return ((IConnectable)lookup.tile).connectStraight((IConnectable)this, lookup.otherDirection, -1);
        }
        return false;
    }
}

