/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.MaskedRedstonePart;
import codechicken.multipart.api.part.redstone.RedstonePart;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.RedstoneCenterLookup;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.core.part.IPropagationCenterPart;
import mrtjp.projectred.core.part.IPropagationPart;
import mrtjp.projectred.core.part.IRedstonePropagationPart;
import mrtjp.projectred.core.part.IRedwirePart;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.part.BaseCenterWirePart;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public abstract class FramedRedwirePart
extends BaseCenterWirePart
implements IRedstonePropagationPart,
IPropagationCenterPart,
MaskedRedstonePart,
IRedwirePart {
    private static final int KEY_SIGNAL = 10;
    private byte signal = 0;

    public FramedRedwirePart(WireType wireType) {
        super(wireType);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128344_("signal", this.signal);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.signal = tag.m_128445_("signal");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.signal = packet.readByte();
    }

    @Override
    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 10: {
                this.signal = packet.readByte();
                if (!Configurator.staticWires) break;
                this.tile().markRender();
                break;
            }
            default: {
                super.read(packet, key);
            }
        }
    }

    protected void sendSignalUpdate() {
        this.sendUpdate(10, p -> p.writeByte((int)this.signal));
    }

    @Override
    public void maskChangeEvent(boolean internalChange, boolean externalChange) {
        super.maskChangeEvent(internalChange, externalChange);
        RedstonePropagator.logCalculation();
        RedstonePropagator.propagateTo((IPropagationPart)this, (int)(internalChange || externalChange ? 2 : 0));
    }

    protected int redstoneSignalLevel() {
        return RedstonePropagator.canRedwiresProvidePower() ? ((this.signal & 0xFF) + 16) / 17 : 0;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return this.redstoneSignalLevel();
    }

    public boolean canConnectRedstone(int side) {
        return true;
    }

    public int getConnectionMask(int side) {
        return 16;
    }

    public boolean canConnectPart(IConnectable part, int dir) {
        return part instanceof IRedwirePart;
    }

    public boolean discoverStraightOverride(int s) {
        boolean prevCanConnectRW = RedstonePropagator.canConnectRedwires();
        RedstonePropagator.setCanConnectRedwires((boolean)false);
        boolean discovered = (RedstoneInteractions.otherConnectionMask((LevelReader)this.level(), (BlockPos)this.pos(), (int)s, (boolean)false) & RedstoneInteractions.connectionMask((MultiPart)this, (int)s)) != 0;
        RedstonePropagator.setCanConnectRedwires((boolean)prevCanConnectRW);
        return discovered;
    }

    public boolean discoverInternalOverride(int s) {
        MultiPart part = this.tile().getSlottedPart(s);
        if (part instanceof RedstonePart) {
            return ((RedstonePart)part).canConnectRedstone(s ^ 1);
        }
        return false;
    }

    public int getSignal() {
        return this.signal & 0xFF;
    }

    public void setSignal(int signal) {
        this.signal = (byte)signal;
    }

    public void onSignalUpdate() {
        this.sendSignalUpdate();
    }

    public int calculateSignal() {
        RedstonePropagator.setDustProvidesPower((boolean)false);
        RedstonePropagator.setRedwiresProvidePower((boolean)false);
        int signal = 0;
        for (int s = 0; s < 6; ++s) {
            CenterLookup lookup;
            int sig = 0;
            if (this.maskConnectsIn(s)) {
                lookup = CenterLookup.lookupInsideFace((Level)this.level(), (BlockPos)this.pos(), (int)s);
                sig = this.resolveSignal(lookup);
            } else if (this.maskConnectsOut(s) && (sig = this.resolveSignal(lookup = CenterLookup.lookupStraightCenter((Level)this.level(), (BlockPos)this.pos(), (int)s))) == 0) {
                sig = RedstoneCenterLookup.resolveVanillaSignal((CenterLookup)lookup, (MultiPart)this);
            }
            signal = Math.max(sig, signal);
        }
        RedstonePropagator.setDustProvidesPower((boolean)true);
        RedstonePropagator.setRedwiresProvidePower((boolean)true);
        return signal;
    }

    public void propagateOther(int mode) {
        for (int s = 0; s < 6; ++s) {
            if (this.maskConnects(s)) continue;
            RedstonePropagator.addNeighborChange((Level)this.level(), (BlockPos)this.pos(), (BlockPos)this.posOfStraight(s));
        }
    }

    public int getRedwireSignal(int dir) {
        return this.getSignal();
    }

    public boolean diminishOnSide(int side) {
        return true;
    }

    protected int resolveSignal(CenterLookup lookup) {
        return RedstoneCenterLookup.resolveSignal((CenterLookup)lookup, (boolean)true);
    }
}

