/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block.be;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.violetmoon.quark.content.automation.block.CrafterBlock;
import org.violetmoon.quark.content.automation.inventory.CrafterMenu;
import org.violetmoon.quark.content.automation.module.CrafterModule;

public class CrafterBlockEntity
extends BaseContainerBlockEntity
implements CraftingContainer,
WorldlyContainer {
    private static final DispenseItemBehavior BEHAVIOR = new CraftDispenseBehavior();
    public final NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    public final ResultContainer result = new ResultContainer();
    public final boolean[] blocked = new boolean[9];
    public final ContainerData delegate;
    private boolean didInitialScan = false;

    public CrafterBlockEntity(final BlockPos pos, BlockState state) {
        super(CrafterModule.blockEntityType, pos, state);
        this.delegate = new ContainerData(){

            public int m_6413_(int index) {
                int res = CrafterBlockEntity.this.f_58857_.m_8055_(pos).m_61143_(CrafterBlock.POWER) == CrafterBlock.PowerState.TRIGGERED ? 1 : 0;
                for (int i = 0; i < 9; ++i) {
                    if (!CrafterBlockEntity.this.blocked[i]) continue;
                    res |= 1 << i + 1;
                }
                return res;
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ListTag list = new ListTag();
        for (boolean b : this.blocked) {
            list.add((Object)ByteTag.m_128273_((boolean)b));
        }
        nbt.m_128365_("Blocked", (Tag)list);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.stacks);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("Blocked")) {
            ListTag list = nbt.m_128437_("Blocked", 1);
            for (int i = 0; i < list.size() && i < 9; ++i) {
                this.blocked[i] = ((ByteTag)list.get(i)).m_7063_() != 0;
            }
        }
        ContainerHelper.m_18980_((CompoundTag)nbt, this.stacks);
    }

    public void craft() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sw = (ServerLevel)level;
            this.update();
            BlockSourceImpl blockSource = new BlockSourceImpl(sw, this.f_58858_);
            ItemStack itemStack = this.result.m_8020_(0);
            if (!itemStack.m_41619_()) {
                Direction direction = (Direction)this.m_58900_().m_61143_((Property)CrafterBlock.FACING);
                Container inventory = HopperBlockEntity.m_59390_((Level)this.f_58857_, (BlockPos)this.f_58858_.m_121945_(direction));
                if (inventory == null) {
                    BEHAVIOR.m_6115_((BlockSource)blockSource, itemStack);
                } else {
                    if (!this.hasSpace(inventory, direction, itemStack)) {
                        return;
                    }
                    if (inventory instanceof CrafterBlockEntity) {
                        int count = itemStack.m_41613_();
                        for (int i = 0; i < count; ++i) {
                            ItemStack is = itemStack.m_41777_();
                            is.m_41764_(1);
                            HopperBlockEntity.m_59326_((Container)this.result, (Container)inventory, (ItemStack)is, (Direction)direction.m_122424_());
                        }
                    } else {
                        HopperBlockEntity.m_59326_((Container)this.result, (Container)inventory, (ItemStack)itemStack, (Direction)direction.m_122424_());
                    }
                }
                this.takeItems();
                this.update();
            }
        }
    }

    private static IntStream getAvailableSlots(Container inventory, Direction side) {
        return inventory instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)inventory).m_7071_(side)) : IntStream.range(0, inventory.m_6643_());
    }

    public boolean hasSpace(Container inv, Direction dir, ItemStack stack) {
        IntStream stream = CrafterBlockEntity.getAvailableSlots(inv, dir);
        int inserted = 0;
        int slotMax = Math.min(stack.m_41741_(), inv.m_6893_());
        if (CrafterModule.useEmiLogic && inv instanceof CrafterBlockEntity) {
            slotMax = 1;
        }
        for (int i : stream.toArray()) {
            WorldlyContainer si;
            if (inv instanceof WorldlyContainer && !(si = (WorldlyContainer)inv).m_7155_(i, stack, dir)) continue;
            ItemStack is = inv.m_8020_(i);
            if (is.m_41619_()) {
                inserted += slotMax;
            } else if (ItemStack.m_150942_((ItemStack)is, (ItemStack)stack) && is.m_41613_() < slotMax) {
                inserted += slotMax - is.m_41613_();
            }
            if (inserted < stack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public void takeItems() {
        NonNullList defaultedList = this.f_58857_.m_7465_().m_44069_(RecipeType.f_44107_, (Container)this, this.f_58857_);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockSourceImpl blockSource = new BlockSourceImpl(serverLevel, this.f_58858_);
            for (int i = 0; i < defaultedList.size(); ++i) {
                ItemStack itemInCrafter = this.m_8020_(i);
                ItemStack remainingItem = (ItemStack)defaultedList.get(i);
                if (remainingItem.m_41619_()) {
                    itemInCrafter.m_41774_(1);
                    continue;
                }
                BEHAVIOR.m_6115_((BlockSource)blockSource, remainingItem);
                itemInCrafter.m_41774_(itemInCrafter.m_41613_());
            }
        }
        this.update();
    }

    public int getComparatorOutput() {
        int out = 0;
        for (int i = 0; i < 9; ++i) {
            if (!this.blocked[i] && this.m_8020_(i).m_41619_()) continue;
            ++out;
        }
        return out;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CrafterBlockEntity be) {
        if (!be.didInitialScan && !world.f_46443_) {
            be.update();
            be.didInitialScan = true;
        }
    }

    public static ItemStack getResult(Level world, CraftingContainer craftingInventory) {
        CraftingRecipe craftingRecipe;
        ItemStack stack;
        Optional optional = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, world);
        if (optional.isPresent() && (stack = (craftingRecipe = (CraftingRecipe)optional.get()).m_5874_((Container)craftingInventory, world.m_9598_())).m_246617_(world.m_246046_())) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void update() {
        ItemStack stack = CrafterBlockEntity.getResult(this.f_58857_, this);
        this.result.m_6836_(0, stack);
        this.f_58857_.m_46717_(this.f_58858_, CrafterModule.block);
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = ContainerHelper.m_18969_(this.stacks, (int)slot, (int)amount);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        this.update();
        return stack;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = ContainerHelper.m_18966_(this.stacks, (int)slot);
        this.update();
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        this.update();
    }

    public int m_6643_() {
        return 9;
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new CrafterMenu(syncId, playerInventory, it -> new TransientCraftingContainer((AbstractContainerMenu)it, 3, 3, this.stacks), this.result, this.delegate, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_()));
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.quark.crafter");
    }

    public void m_5809_(StackedContents finder) {
        for (ItemStack itemstack : this.stacks) {
            finder.m_36466_(itemstack);
        }
    }

    public int m_39347_() {
        return 3;
    }

    public int m_39346_() {
        return 3;
    }

    public List<ItemStack> m_280657_() {
        return this.stacks;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        ItemStack stackInSlot = this.m_8020_(slot);
        boolean allowed = stackInSlot.m_41619_();
        if (!CrafterModule.useEmiLogic && !allowed) {
            int min = 999;
            for (int i = 0; i < 9; ++i) {
                ItemStack testStack;
                if (this.blocked[i] || !(testStack = this.m_8020_(i)).m_41619_() && !ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)testStack)) continue;
                min = Math.min(min, testStack.m_41613_());
            }
            return stackInSlot.m_41613_() == min;
        }
        boolean blockedSlot = this.blocked[slot];
        boolean powered = ((CrafterBlock.PowerState)((Object)this.f_58857_.m_8055_(this.f_58858_).m_61143_(CrafterBlock.POWER))).powered();
        return allowed && !blockedSlot && (CrafterModule.allowItemsWhilePowered || !powered);
    }

    public int[] m_7071_(Direction side) {
        int ct = 0;
        for (boolean bl : this.blocked) {
            if (bl) continue;
            ++ct;
        }
        int[] ret = new int[ct];
        int i = 0;
        for (int j = 0; j < this.blocked.length; ++j) {
            if (this.blocked[j]) continue;
            ret[i] = j;
            ++i;
        }
        return ret;
    }

    private static class CraftDispenseBehavior
    implements DispenseItemBehavior {
        private CraftDispenseBehavior() {
        }

        public final ItemStack m_6115_(BlockSource blockSource, ItemStack itemStack) {
            ItemStack itemStack2 = this.dispenseSilently(blockSource, itemStack);
            this.playSound(blockSource);
            this.spawnParticles(blockSource, (Direction)blockSource.m_6414_().m_61143_((Property)CrafterBlock.FACING));
            return itemStack2;
        }

        protected ItemStack dispenseSilently(BlockSource pointer, ItemStack stack) {
            Direction direction = (Direction)pointer.m_6414_().m_61143_((Property)CrafterBlock.FACING);
            Position position = CraftDispenseBehavior.getOutputLocation(pointer);
            CraftDispenseBehavior.spawnItem((Level)pointer.m_7727_(), stack, 6, direction, position);
            return stack;
        }

        public static void spawnItem(Level world, ItemStack stack, int speed, Direction side, Position pos) {
            double d = pos.m_7096_();
            double e = pos.m_7098_();
            double f = pos.m_7094_();
            e = side.m_122434_() == Direction.Axis.Y ? (e -= 0.125) : (e -= 0.15625);
            ItemEntity itemEntity = new ItemEntity(world, d, e, f, stack);
            double g = world.f_46441_.m_188500_() * 0.1 + 0.2;
            itemEntity.m_20334_(world.f_46441_.m_216328_((double)side.m_122429_() * g, 0.0172275 * (double)speed), world.f_46441_.m_216328_(0.2, 0.0172275 * (double)speed), world.f_46441_.m_216328_((double)side.m_122431_() * g, 0.0172275 * (double)speed));
            world.m_7967_((Entity)itemEntity);
        }

        protected void playSound(BlockSource pointer) {
            pointer.m_7727_().m_46796_(1000, pointer.m_7961_(), 0);
        }

        protected void spawnParticles(BlockSource pointer, Direction side) {
            pointer.m_7727_().m_46796_(2000, pointer.m_7961_(), side.m_122411_());
        }

        private static Position getOutputLocation(BlockSource pointer) {
            Direction direction = (Direction)pointer.m_6414_().m_61143_((Property)CrafterBlock.FACING);
            return pointer.m_7961_().m_252807_().m_82520_(0.7 * (double)direction.m_122429_(), 0.7 * (double)direction.m_122430_(), 0.7 * (double)direction.m_122431_());
        }
    }
}

