/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.entity.Stoneling;

public class RunAndPoofGoal<T extends Entity>
extends Goal {
    private final Predicate<Entity> canBeSeenSelector = target -> target != null && target.m_6084_() && entity.m_21574_().m_148306_(target) && !entity.m_7307_((Entity)target);
    protected Stoneling entity;
    private final double farSpeed;
    private final double nearSpeed;
    protected T closestLivingEntity;
    private final float avoidDistance;
    private Path path;
    private final PathNavigation navigation;
    private final Class<T> classToAvoid;
    private final Predicate<T> avoidTargetSelector;

    public RunAndPoofGoal(Stoneling entity, Class<T> classToAvoid, float avoidDistance, double farSpeed, double nearSpeed) {
        this(entity, classToAvoid, t -> true, avoidDistance, farSpeed, nearSpeed);
    }

    public RunAndPoofGoal(Stoneling entity, Class<T> classToAvoid, Predicate<T> avoidTargetSelector, float avoidDistance, double farSpeed, double nearSpeed) {
        this.entity = entity;
        this.classToAvoid = classToAvoid;
        this.avoidTargetSelector = avoidTargetSelector;
        this.avoidDistance = avoidDistance;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.navigation = entity.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.entity.isPlayerMade() || !this.entity.isStartled()) {
            return false;
        }
        List entities = this.entity.m_9236_().m_6443_(this.classToAvoid, this.entity.m_20191_().m_82377_((double)this.avoidDistance, 3.0, (double)this.avoidDistance), entity -> EntitySelector.f_20406_.test(entity) && this.canBeSeenSelector.test((Entity)entity) && this.avoidTargetSelector.test((Entity)entity));
        if (entities.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (Entity)entities.get(0);
        Vec3 target = DefaultRandomPos.m_148407_((PathfinderMob)this.entity, (int)16, (int)7, (Vec3)this.closestLivingEntity.m_20182_());
        if (target != null && this.closestLivingEntity.m_20275_(target.f_82479_, target.f_82480_, target.f_82481_) < this.closestLivingEntity.m_20280_((Entity)this.entity)) {
            return false;
        }
        if (target != null) {
            this.path = this.navigation.m_26524_(target.f_82479_, target.f_82480_, target.f_82481_, 0);
        }
        return target == null || this.path != null;
    }

    public boolean m_8045_() {
        if (this.path == null || this.navigation.m_26571_()) {
            return false;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Vec3 epos = this.entity.m_20182_();
        for (int i = 0; i < 8; ++i) {
            int j = Mth.m_14107_((double)(epos.f_82479_ + (double)(((float)(i % 2) - 0.5f) * 0.1f) + (double)this.entity.m_20192_()));
            int k = Mth.m_14107_((double)(epos.f_82480_ + (double)(((float)((i >> 1) % 2) - 0.5f) * this.entity.m_20205_() * 0.8f)));
            int l = Mth.m_14107_((double)(epos.f_82481_ + (double)(((float)((i >> 2) % 2) - 0.5f) * this.entity.m_20205_() * 0.8f)));
            if (pos.m_123341_() == k && pos.m_123342_() == j && pos.m_123343_() == l) continue;
            pos.m_122178_(k, j, l);
            if (!this.entity.m_9236_().m_8055_((BlockPos)pos).m_280555_()) continue;
            return false;
        }
        return true;
    }

    public void m_8056_() {
        Vec3 epos = this.entity.m_20182_();
        if (this.path != null) {
            this.navigation.m_26536_(this.path, this.farSpeed);
        }
        this.entity.m_9236_().m_6263_(null, epos.f_82479_, epos.f_82480_, epos.f_82481_, QuarkSounds.ENTITY_STONELING_MEEP, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public void m_8041_() {
        this.closestLivingEntity = null;
        Level level = this.entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)level;
            Vec3 epos = this.entity.m_20182_();
            ws.m_8767_((ParticleOptions)ParticleTypes.f_123796_, epos.f_82479_, epos.f_82480_, epos.f_82481_, 40, 0.5, 0.5, 0.5, 0.1);
            ws.m_8767_((ParticleOptions)ParticleTypes.f_123813_, epos.f_82479_, epos.f_82480_, epos.f_82481_, 20, 0.5, 0.5, 0.5, 0.0);
        }
        for (Entity passenger : this.entity.m_146897_()) {
            if (passenger instanceof Player) continue;
            passenger.m_146870_();
        }
        this.entity.m_146870_();
    }

    public void m_8037_() {
        if (this.entity.m_20280_((Entity)this.closestLivingEntity) < 49.0) {
            this.entity.m_21573_().m_26517_(this.nearSpeed);
        } else {
            this.entity.m_21573_().m_26517_(this.farSpeed);
        }
    }
}

