/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.violetmoon.quark.content.mobs.entity.Foxhound;

public class FoxhoundModel
extends AgeableListModel<Foxhound> {
    public final ModelPart head;
    public final ModelPart rightFrontLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart rightBackLeg;
    public final ModelPart leftBackLeg;
    public final ModelPart body;
    public final ModelPart snout;
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    public final ModelPart tail;
    public final ModelPart fluff;

    public FoxhoundModel(ModelPart root) {
        super(false, 5.0f, 2.5f);
        this.head = root.m_171324_("head");
        this.rightFrontLeg = root.m_171324_("rightFrontLeg");
        this.leftFrontLeg = root.m_171324_("leftFrontLeg");
        this.rightBackLeg = root.m_171324_("rightBackLeg");
        this.leftBackLeg = root.m_171324_("leftBackLeg");
        this.body = root.m_171324_("body");
        this.snout = this.head.m_171324_("snout");
        this.rightEar = this.head.m_171324_("rightEar");
        this.leftEar = this.head.m_171324_("leftEar");
        this.tail = this.body.m_171324_("tail");
        this.fluff = this.body.m_171324_("fluff");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        float zOff = 5.5f;
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(-4.0f, -3.0f, -6.0f, 8.0f, 6.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)14.5f, (float)-5.5f, (float)0.0f, (float)1.0f, (float)0.0f));
        head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(0, 47).m_171481_(-4.0f, -5.0f, -5.0f, 2.0f, 2.0f, 3.0f), PartPose.f_171404_);
        head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(10, 47).m_171481_(2.0f, -5.0f, -5.0f, 2.0f, 2.0f, 3.0f), PartPose.f_171404_);
        head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(29, 18).m_171481_(-2.0f, 1.0f, -10.0f, 4.0f, 2.0f, 4.0f), PartPose.f_171404_);
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171481_(-4.0f, -12.0f, 0.0f, 8.0f, 12.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)6.5f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171481_(-2.0f, -4.0f, 0.0f, 4.0f, 5.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.5f, (float)-1.3089969f, (float)0.0f, (float)0.0f));
        body.m_171599_("fluff", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171481_(-5.0f, 0.0f, -4.0f, 10.0f, 8.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-13.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("leftBackLeg", CubeListBuilder.m_171558_().m_171514_(36, 32).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.m_171423_((float)3.0f, (float)12.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(24, 32).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.m_171423_((float)-3.0f, (float)12.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(12, 32).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void prepareMobModel(Foxhound hound, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.f_104203_ = hound.m_6784_() > 0 ? -0.65449846f : -1.3089969f + Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.head.f_104204_ = hound.m_30448_(partialTickTime) - hound.m_30432_(partialTickTime, 0.0f);
        this.head.f_104203_ = 0.0f;
        this.body.f_104204_ = hound.m_30432_(partialTickTime, -0.16f);
        this.tail.f_104204_ = hound.m_30432_(partialTickTime, -0.2f);
        if (hound.m_5803_()) {
            this.head.m_104227_(1.0f, 20.5f, -5.5f);
            this.setAngle(this.head, 0.0f, 0.7853982f, -0.04363323f);
            this.body.m_104227_(0.0f, 20.0f, 6.5f);
            this.setAngle(this.body, 1.5707964f, 0.0f, 1.5707964f);
            this.tail.m_104227_(0.0f, -1.0f, 1.0f);
            this.setAngle(this.tail, 2.5497515f, -0.22759093f, 0.0f);
            this.rightFrontLeg.m_104227_(0.0f, 18.0f, -3.5f);
            this.leftFrontLeg.m_104227_(2.0f, 21.0f, -4.5f);
            this.rightBackLeg.m_104227_(0.0f, 22.0f, 5.5f);
            this.leftBackLeg.m_104227_(3.0f, 20.0f, 4.5f);
            this.setAngle(this.rightFrontLeg, 0.21816616f, 0.43633232f, 1.3089969f);
            this.setAngle(this.leftFrontLeg, 0.0f, 0.0f, 1.3962634f);
            this.setAngle(this.rightBackLeg, -1.0471976f, -0.08726646f, 1.4835298f);
            this.setAngle(this.leftBackLeg, -0.7853982f, 0.0f, 1.2217305f);
        } else if (hound.m_21825_()) {
            this.head.m_104227_(0.0f, 12.0f, -3.5f);
            this.body.m_104227_(0.0f, 23.0f, 1.5f);
            this.setAngle(this.body, 0.7853982f, this.body.f_104204_, 0.0f);
            this.tail.m_104227_(0.0f, 0.0f, 2.0f);
            this.setAngle(this.tail, -1.1f, -0.0f, 0.0f);
            this.rightFrontLeg.m_104227_(-2.0f, 12.0f, -4.25f);
            this.leftFrontLeg.m_104227_(2.0f, 12.0f, -4.25f);
            this.rightBackLeg.m_104227_(-3.0f, 21.0f, 4.5f);
            this.leftBackLeg.m_104227_(3.0f, 21.0f, 4.5f);
            this.setAngle(this.rightFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setAngle(this.leftFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setAngle(this.rightBackLeg, -1.3089969f, 0.3926991f, 0.0f);
            this.setAngle(this.leftBackLeg, -1.3089969f, -0.3926991f, 0.0f);
        } else {
            this.head.m_104227_(0.0f, 14.5f, -5.5f);
            this.body.m_104227_(0.0f, 17.0f, 6.5f);
            this.setAngle(this.body, 1.5707964f, this.body.f_104204_, 0.0f);
            this.tail.m_104227_(0.0f, 0.0f, 1.5f);
            this.rightFrontLeg.m_104227_(-2.0f, 12.0f, -3.5f);
            this.leftFrontLeg.m_104227_(2.0f, 12.0f, -3.5f);
            this.rightBackLeg.m_104227_(-3.0f, 12.0f, 4.0f);
            this.leftBackLeg.m_104227_(3.0f, 12.0f, 4.0f);
            this.setAngle(this.rightFrontLeg, Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setAngle(this.leftFrontLeg, Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setAngle(this.rightBackLeg, Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setAngle(this.leftBackLeg, Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
        }
    }

    public void setupAnim(Foxhound entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.m_5803_()) {
            this.head.f_104204_ += netHeadYaw * ((float)Math.PI / 180);
            this.head.f_104203_ += headPitch * ((float)Math.PI / 180);
        } else {
            this.head.f_104204_ += Mth.m_14089_((float)((float)entity.f_19797_ / 30.0f)) / 20.0f;
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightBackLeg, (Object)this.leftBackLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }

    public void setAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

