/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.GameRules;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.player.ZPlayer;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks", antiOverlap={"nerb"})
public class AutomaticRecipeUnlockModule
extends ZetaModule {
    @Config(description="A list of recipe names that should NOT be added in by default")
    public static List<String> ignoredRecipes = Lists.newArrayList();
    @Config
    public static boolean forceLimitedCrafting = false;
    @Config
    public static boolean disableRecipeBook = false;
    @Config(description="If enabled, advancements granting recipes will be stopped from loading, potentially reducing the lagspike on first world join.")
    public static boolean filterRecipeAdvancements = true;
    private static boolean staticEnabled;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    @PlayEvent
    public void onPlayerLoggedIn(ZPlayer.LoggedIn event) {
        ServerPlayer spe;
        MinecraftServer server;
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer && (server = (spe = (ServerPlayer)player).m_20194_()) != null) {
            int shift;
            ArrayList<Recipe> recipes = new ArrayList<Recipe>(server.m_129894_().m_44051_());
            recipes.removeIf(recipe -> recipe == null || recipe.m_8043_(event.getPlayer().m_9236_().m_9598_()) == null || ignoredRecipes.contains(Objects.toString(recipe.m_6423_())) || recipe.m_8043_(event.getPlayer().m_9236_().m_9598_()).m_41619_());
            int idx = 0;
            int maxShift = 1000;
            int size = recipes.size();
            do {
                shift = size - idx;
                int effShift = Math.min(maxShift, shift);
                List sectionedRecipes = recipes.subList(idx, idx + effShift);
                player.m_7281_(sectionedRecipes);
                idx += effShift;
            } while (shift > maxShift);
            if (forceLimitedCrafting) {
                ((GameRules.BooleanValue)player.m_9236_().m_46469_().m_46170_(GameRules.f_46151_)).m_46246_(true, server);
            }
        }
    }

    public static void removeRecipeAdvancements(Map<ResourceLocation, Advancement.Builder> builders) {
        if (!staticEnabled || !filterRecipeAdvancements) {
            return;
        }
        int i = 0;
        Iterator<Map.Entry<ResourceLocation, Advancement.Builder>> iterator = builders.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, Advancement.Builder> entry = iterator.next();
            if (!entry.getKey().m_135815_().startsWith("recipes/") || !entry.getValue().m_138405_().containsKey("has_the_recipe")) continue;
            iterator.remove();
            ++i;
        }
        Quark.LOG.info("[Automatic Recipe Unlock] Removed {} recipe advancements", (Object)i);
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends AutomaticRecipeUnlockModule {
        @PlayEvent
        public void onInitGui(ZScreen.Init.Post event) {
            Screen gui = event.getScreen();
            if (disableRecipeBook && gui instanceof RecipeUpdateListener) {
                Minecraft.m_91087_().f_91074_.m_108631_().m_12684_().m_12736_(RecipeBookType.CRAFTING, false);
                List widgets = event.getListenersList();
                for (GuiEventListener w : widgets) {
                    if (!(w instanceof ImageButton)) continue;
                    event.removeListener(w);
                    return;
                }
            }
        }

        @PlayEvent
        public void clientTick(ZClientTick.End event) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91074_.f_19797_ < 20) {
                ToastComponent toasts = mc.m_91300_();
                Deque toastQueue = toasts.f_94916_;
                for (Toast toast : toastQueue) {
                    if (!(toast instanceof RecipeToast)) continue;
                    RecipeToast recipeToast = (RecipeToast)toast;
                    List stacks = recipeToast.f_94805_;
                    if (stacks.size() <= 100) continue;
                    toastQueue.remove(toast);
                    return;
                }
            }
        }
    }
}

