/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.gui.ResearchTableContainer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ResearchActionPacket {
    final Action action;
    final int index;

    public ResearchActionPacket(Action action, int index) {
        this.action = action;
        this.index = index;
    }

    public ResearchActionPacket(Action action) {
        this(action, 0);
    }

    public static void encode(ResearchActionPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.action.ordinal());
        buffer.writeInt(object.index);
    }

    public static ResearchActionPacket decode(FriendlyByteBuf buffer) {
        Action action = Action.values()[buffer.readInt()];
        int index = buffer.readInt();
        return new ResearchActionPacket(action, index);
    }

    public static void consume(ResearchActionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER);
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            AbstractContainerMenu menu = player.f_36096_;
            Level world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            if (world != null && menu instanceof ResearchTableContainer) {
                ResearchTableContainer rc = (ResearchTableContainer)menu;
                if (packet.action == Action.SUBMIT_GOAL) {
                    rc.trySubmitGoal((Player)player, packet.index);
                } else if (packet.action == Action.STAMP) {
                    rc.tryStamp((Player)player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Action {
        SUBMIT_GOAL,
        STAMP;

    }
}

