/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.ritual.LocationRitual;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocationRitualRecipe
extends RitualRecipe {
    ResourceLocation structureTagKey;

    public LocationRitualRecipe(ResourceLocation id, ResourceLocation structure, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, float healthRequirement) {
        super(id, reagent, pedestalItems, focusItems, healthRequirement);
        this.structureTagKey = structure;
    }

    @Override
    public Ritual getRitual() {
        return new LocationRitual((TagKey<Structure>)TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)this.structureTagKey)).setRegistryName(this.id);
    }

    @Override
    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon:ritual_brazier_location");
        LocationRitualRecipe.addRitualElements(this, jsonobject);
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("structure", this.structureTagKey.toString());
        jsonobject.add("output", (JsonElement)resultObj);
        return jsonobject;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.LOCATION_RITUAL_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.LOCATION_RITUAL_TYPE.get();
    }

    public static class Serializer
    extends RitualRecipe.Serializer<LocationRitualRecipe> {
        @NotNull
        public LocationRitualRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Ingredient reagent = Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"reagent"));
            float healthRequirement = json.has("healthRequirement") ? GsonHelper.m_13915_((JsonObject)json, (String)"healthRequirement") : 0.0f;
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            List<Ingredient> stacks = RitualRecipe.getPedestalItems(pedestalItems);
            JsonArray focusItems = GsonHelper.m_13933_((JsonObject)json, (String)"focusItems");
            List<Ingredient> foci = RitualRecipe.getPedestalItems(focusItems);
            JsonObject resultObj = GsonHelper.m_13930_((JsonObject)json, (String)"output");
            ResourceLocation structure = new ResourceLocation(GsonHelper.m_13906_((JsonObject)resultObj, (String)"structure"));
            return new LocationRitualRecipe(recipeId, structure, reagent, stacks, foci, healthRequirement);
        }

        @Nullable
        public LocationRitualRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, @NotNull FriendlyByteBuf pBuffer) {
            int length = pBuffer.readInt();
            int length2 = pBuffer.readInt();
            Ingredient reagent = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            ArrayList<Ingredient> foci = new ArrayList<Ingredient>();
            for (int i = 0; i < length2; ++i) {
                try {
                    foci.add(Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            float healthRequirement = pBuffer.readFloat();
            ResourceLocation structure = pBuffer.m_130281_();
            return new LocationRitualRecipe(pRecipeId, structure, reagent, stacks, foci, healthRequirement);
        }

        @Override
        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, @NotNull LocationRitualRecipe pRecipe) {
            super.toNetwork(pBuffer, pRecipe);
            pBuffer.m_130085_(pRecipe.structureTagKey);
        }
    }
}

